/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.metal;

import com.sun.java.swing.Icon;
import com.sun.java.swing.plaf.metal.BumpBuffer;
import com.sun.java.swing.plaf.metal.MetalLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

class MetalBumps
implements Icon,
Serializable {
    protected int xBumps;
    protected int yBumps;
    protected Color topColor = MetalLookAndFeel.getPrimaryControlHighlight();
    protected Color shadowColor = MetalLookAndFeel.getPrimaryControlDarkShadow();
    protected Color backColor = MetalLookAndFeel.getPrimaryControlShadow();
    protected static Vector buffers = new Vector();
    protected BumpBuffer buffer;

    public MetalBumps(Dimension dimension) {
        this(dimension.width, dimension.height);
    }

    public MetalBumps(int n, int n2) {
        this.setBumpArea(n, n2);
        this.buffer = this.getBuffer(this.topColor, this.shadowColor, this.backColor);
        if (this.buffer == null) {
            this.createBuffer();
        }
    }

    public MetalBumps(int n, int n2, Color color, Color color2, Color color3) {
        this.setBumpArea(n, n2);
        this.setBumpColors(color, color2, color3);
        this.buffer = this.getBuffer(this.topColor, this.shadowColor, this.backColor);
        if (this.buffer == null) {
            this.createBuffer();
        }
    }

    protected void createBuffer() {
        this.buffer = new BumpBuffer(this.topColor, this.shadowColor, this.backColor);
        buffers.addElement(this.buffer);
    }

    protected BumpBuffer getBuffer(Color color, Color color2, Color color3) {
        BumpBuffer bumpBuffer = null;
        Enumeration enumeration = buffers.elements();
        while (enumeration.hasMoreElements()) {
            BumpBuffer bumpBuffer2 = (BumpBuffer)enumeration.nextElement();
            if (!bumpBuffer2.hasSameColors(color, color2, color3)) continue;
            bumpBuffer = bumpBuffer2;
            break;
        }
        return bumpBuffer;
    }

    public void setBumpArea(Dimension dimension) {
        this.setBumpArea(dimension.width, dimension.height);
    }

    public void setBumpArea(int n, int n2) {
        this.xBumps = n / 2;
        this.yBumps = n2 / 2;
    }

    public void setBumpColors(Color color, Color color2, Color color3) {
        this.topColor = color;
        this.shadowColor = color2;
        this.backColor = color3;
        this.buffer = this.getBuffer(this.topColor, this.shadowColor, this.backColor);
        if (this.buffer == null) {
            this.createBuffer();
        }
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Rectangle rectangle = graphics.getClipBounds();
        Rectangle rectangle2 = new Rectangle(n, n2, this.getIconWidth(), this.getIconHeight());
        Rectangle rectangle3 = rectangle2.intersection(rectangle);
        graphics.setClip(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        int n3 = this.buffer.getImageSize().width;
        int n4 = this.buffer.getImageSize().height;
        int n5 = this.getIconWidth() / n3 + 1;
        int n6 = this.getIconHeight() / n4 + 1;
        int n7 = 0;
        while (n7 < n6) {
            int n8 = 0;
            while (n8 < n5) {
                graphics.drawImage(this.buffer.getImage(), n + n8 * n3, n2 + n7 * n4, null);
                ++n8;
            }
            ++n7;
        }
        graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public int getIconWidth() {
        return this.xBumps * 2;
    }

    public int getIconHeight() {
        return this.yBumps * 2;
    }
}

