/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.MenuItemUI;
import javax.swing.plaf.PopupMenuUI;

public class JMenu
extends JMenuItem
implements Accessible,
MenuElement {
    private static final String uiClassID = "MenuUI";
    private JPopupMenu popupMenu;
    private ChangeListener menuChangeListener = null;
    private MenuEvent menuEvent = null;
    private static Hashtable listenerRegistry = null;
    private int delay;
    protected WinListener popupListener;
    static /* synthetic */ Class class$javax$swing$event$MenuListener;

    public JMenu() {
        this("");
    }

    public JMenu(String string) {
        super(string);
    }

    public JMenu(String string, boolean bl) {
        this(string);
    }

    public Component add(Component component) {
        AccessibleContext accessibleContext;
        if (component instanceof JComponent && (accessibleContext = ((JComponent)component).getAccessibleContext()) != null) {
            accessibleContext.setAccessibleParent(this);
        }
        this.ensurePopupMenuCreated();
        this.popupMenu.add(component);
        return component;
    }

    public JMenuItem add(String string) {
        return this.add(new JMenuItem(string));
    }

    public JMenuItem add(Action action) {
        JMenuItem jMenuItem = new JMenuItem((String)action.getValue("Name"), (Icon)action.getValue("SmallIcon"));
        jMenuItem.setHorizontalTextPosition(4);
        jMenuItem.setVerticalTextPosition(0);
        jMenuItem.setEnabled(action.isEnabled());
        jMenuItem.addActionListener(action);
        this.add(jMenuItem);
        this.registerMenuItemForAction(jMenuItem, action);
        return jMenuItem;
    }

    public JMenuItem add(JMenuItem jMenuItem) {
        AccessibleContext accessibleContext = jMenuItem.getAccessibleContext();
        accessibleContext.setAccessibleParent(this);
        this.ensurePopupMenuCreated();
        return this.popupMenu.add(jMenuItem);
    }

    public void addMenuListener(MenuListener menuListener) {
        this.listenerList.add(class$javax$swing$event$MenuListener != null ? class$javax$swing$event$MenuListener : (class$javax$swing$event$MenuListener = JMenu.class$("javax.swing.event.MenuListener")), menuListener);
    }

    public void addSeparator() {
        this.ensurePopupMenuCreated();
        this.popupMenu.addSeparator();
    }

    private MenuElement[] buildMenuElementArray(JMenu jMenu) {
        Vector<JComponent> vector = new Vector<JComponent>();
        Component component = jMenu.getPopupMenu();
        while (true) {
            if (component instanceof JPopupMenu) {
                JPopupMenu jPopupMenu = component;
                vector.insertElementAt(jPopupMenu, 0);
                component = jPopupMenu.getInvoker();
                continue;
            }
            if (component instanceof JMenu) {
                JMenu jMenu2 = (JMenu)component;
                vector.insertElementAt(jMenu2, 0);
                component = jMenu2.getParent();
                continue;
            }
            if (component instanceof JMenuBar) break;
        }
        JMenuBar jMenuBar = (JMenuBar)component;
        vector.insertElementAt(jMenuBar, 0);
        Object[] objectArray = new MenuElement[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private void clearListenerRegistry() {
        if (listenerRegistry != null) {
            Enumeration enumeration = listenerRegistry.keys();
            while (enumeration.hasMoreElements()) {
                JMenuItem jMenuItem;
                ActionChangedListener actionChangedListener;
                Object k = enumeration.nextElement();
                if (k != this || (actionChangedListener = (ActionChangedListener)listenerRegistry.get(jMenuItem = (JMenuItem)k)) == null) continue;
                Action action = (Action)listenerRegistry.get(actionChangedListener);
                if (action != null) {
                    jMenuItem.removeActionListener(action);
                    action.removePropertyChangeListener(actionChangedListener);
                }
                actionChangedListener.setTarget(null);
            }
            listenerRegistry.clear();
        }
    }

    protected PropertyChangeListener createActionChangeListener(JMenuItem jMenuItem) {
        return new ActionChangedListener(jMenuItem);
    }

    private ChangeListener createMenuChangeListener() {
        return new MenuChangeListener();
    }

    protected WinListener createWinListener(JPopupMenu jPopupMenu) {
        return new WinListener(jPopupMenu);
    }

    public void doClick(int n) {
        MenuElement[] menuElementArray = this.buildMenuElementArray(this);
        MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray);
    }

    private void ensurePopupMenuCreated() {
        if (this.popupMenu == null) {
            JMenu jMenu = this;
            this.popupMenu = new JPopupMenu();
            this.popupMenu.setInvoker(this);
            this.popupListener = this.createWinListener(this.popupMenu);
            this.popupMenu.addPopupMenuListener(new PopupMenuListener(){

                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                    JMenu.this.fireMenuCanceled();
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                }

                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                }
            });
        }
    }

    protected void fireMenuCanceled() {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$MenuListener != null ? class$javax$swing$event$MenuListener : JMenu.class$("javax.swing.event.MenuListener"))) {
                if (objectArray[n + 1] == null) {
                    throw new Error(String.valueOf(this.getText()) + " has a NULL Listener!! " + n);
                }
                if (this.menuEvent == null) {
                    this.menuEvent = new MenuEvent(this);
                }
                ((MenuListener)objectArray[n + 1]).menuCanceled(this.menuEvent);
            }
            n -= 2;
        }
    }

    protected void fireMenuDeselected() {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$MenuListener != null ? class$javax$swing$event$MenuListener : JMenu.class$("javax.swing.event.MenuListener"))) {
                if (objectArray[n + 1] == null) {
                    throw new Error(String.valueOf(this.getText()) + " has a NULL Listener!! " + n);
                }
                if (this.menuEvent == null) {
                    this.menuEvent = new MenuEvent(this);
                }
                ((MenuListener)objectArray[n + 1]).menuDeselected(this.menuEvent);
            }
            n -= 2;
        }
    }

    protected void fireMenuSelected() {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$MenuListener != null ? class$javax$swing$event$MenuListener : JMenu.class$("javax.swing.event.MenuListener"))) {
                if (objectArray[n + 1] == null) {
                    throw new Error(String.valueOf(this.getText()) + " has a NULL Listener!! " + n);
                }
                if (this.menuEvent == null) {
                    this.menuEvent = new MenuEvent(this);
                }
                ((MenuListener)objectArray[n + 1]).menuSelected(this.menuEvent);
            }
            n -= 2;
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJMenu();
        }
        return this.accessibleContext;
    }

    public Component getComponent() {
        return this;
    }

    public int getDelay() {
        return this.delay;
    }

    public JMenuItem getItem(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        Component component = this.getMenuComponent(n);
        if (component instanceof JMenuItem) {
            JMenuItem jMenuItem = (JMenuItem)component;
            return jMenuItem;
        }
        return null;
    }

    public int getItemCount() {
        return this.getMenuComponentCount();
    }

    public Component getMenuComponent(int n) {
        if (this.popupMenu != null) {
            return this.popupMenu.getComponent(n);
        }
        return null;
    }

    public int getMenuComponentCount() {
        int n = 0;
        if (this.popupMenu != null) {
            n = this.popupMenu.getComponentCount();
        }
        return n;
    }

    public Component[] getMenuComponents() {
        if (this.popupMenu != null) {
            return this.popupMenu.getComponents();
        }
        return new Component[0];
    }

    public JPopupMenu getPopupMenu() {
        this.ensurePopupMenuCreated();
        return this.popupMenu;
    }

    private Point getPopupMenuOrigin() {
        int n = 0;
        int n2 = 0;
        JPopupMenu jPopupMenu = this.getPopupMenu();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        Dimension dimension3 = jPopupMenu.getSize();
        if (dimension3.width == 0) {
            dimension3 = jPopupMenu.getPreferredSize();
        }
        Point point = this.getLocationOnScreen();
        Container container = this.getParent();
        if (container instanceof JPopupMenu) {
            n = SwingUtilities.isLeftToRight(this) ? (point.x + dimension2.width + dimension3.width < dimension.width ? dimension2.width : -dimension3.width) : (point.x < dimension3.width ? dimension2.width : -dimension3.width);
            n2 = point.y + dimension3.height < dimension.height ? 0 : dimension2.height - dimension3.height;
        } else {
            n = SwingUtilities.isLeftToRight(this) ? (point.x + dimension3.width < dimension.width ? 0 : dimension2.width - dimension3.width) : (point.x + dimension2.width < dimension3.width ? 0 : dimension2.width - dimension3.width);
            n2 = point.y + dimension2.height + dimension3.height < dimension.height ? dimension2.height : -dimension3.height;
        }
        return new Point(n, n2);
    }

    public MenuElement[] getSubElements() {
        if (this.popupMenu == null) {
            return new MenuElement[0];
        }
        MenuElement[] menuElementArray = new MenuElement[]{this.popupMenu};
        return menuElementArray;
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public void insert(String string, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        this.ensurePopupMenuCreated();
        this.popupMenu.insert(new JMenuItem(string), n);
    }

    public JMenuItem insert(Action action, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        this.ensurePopupMenuCreated();
        JMenuItem jMenuItem = new JMenuItem((String)action.getValue("Name"), (Icon)action.getValue("SmallIcon"));
        jMenuItem.setHorizontalTextPosition(4);
        jMenuItem.setVerticalTextPosition(0);
        jMenuItem.setEnabled(action.isEnabled());
        jMenuItem.addActionListener(action);
        this.popupMenu.insert(jMenuItem, n);
        this.registerMenuItemForAction(jMenuItem, action);
        return jMenuItem;
    }

    public JMenuItem insert(JMenuItem jMenuItem, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        AccessibleContext accessibleContext = jMenuItem.getAccessibleContext();
        accessibleContext.setAccessibleParent(this);
        this.ensurePopupMenuCreated();
        this.popupMenu.insert(jMenuItem, n);
        return jMenuItem;
    }

    public void insertSeparator(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        this.ensurePopupMenuCreated();
        this.popupMenu.insert(new JPopupMenu.Separator(), n);
    }

    public boolean isMenuComponent(Component component) {
        JPopupMenu jPopupMenu;
        if (component == this) {
            return true;
        }
        if (component instanceof JPopupMenu && (jPopupMenu = (JPopupMenu)component) == this.getPopupMenu()) {
            return true;
        }
        int n = this.getMenuComponentCount();
        Component[] componentArray = this.getMenuComponents();
        int n2 = 0;
        while (n2 < n) {
            JMenu jMenu;
            Component component2 = componentArray[n2];
            if (component2 == component) {
                return true;
            }
            if (component2 instanceof JMenu && (jMenu = (JMenu)component2).isMenuComponent(component)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isPopupMenuVisible() {
        this.ensurePopupMenuCreated();
        return this.popupMenu.isVisible();
    }

    public boolean isSelected() {
        return this.getModel().isSelected();
    }

    public boolean isTearOff() {
        throw new Error("boolean isTearOff() {} not yet implemented");
    }

    public boolean isTopLevelMenu() {
        return this.getParent() instanceof JMenuBar;
    }

    public void menuSelectionChanged(boolean bl) {
        this.setSelected(bl);
    }

    protected String paramString() {
        return super.paramString();
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        MenuSelectionManager.defaultManager().processKeyEvent(keyEvent);
        if (keyEvent.isConsumed()) {
            return;
        }
        if (this.isSelected() && (keyEvent.getKeyCode() == 9 || keyEvent.getKeyChar() == '\t')) {
            if ((Boolean)UIManager.get("Menu.consumesTabs") == Boolean.TRUE) {
                keyEvent.consume();
                return;
            }
            MenuSelectionManager.defaultManager().clearSelectedPath();
        }
        super.processKeyEvent(keyEvent);
    }

    private void registerMenuItemForAction(JMenuItem jMenuItem, Action action) {
        PropertyChangeListener propertyChangeListener = this.createActionChangeListener(jMenuItem);
        if (listenerRegistry == null) {
            listenerRegistry = new Hashtable();
        }
        listenerRegistry.put(jMenuItem, propertyChangeListener);
        listenerRegistry.put(propertyChangeListener, action);
        action.addPropertyChangeListener(propertyChangeListener);
    }

    public void remove(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        if (n > this.getItemCount()) {
            throw new IllegalArgumentException("index greater than the number of items.");
        }
        JMenuItem jMenuItem = this.getItem(n);
        if (jMenuItem instanceof JMenuItem) {
            this.unregisterMenuItemForAction(jMenuItem);
        }
        if (this.popupMenu != null) {
            this.popupMenu.remove(n);
        }
    }

    public void remove(Component component) {
        if (this.popupMenu != null) {
            this.popupMenu.remove(component);
        }
    }

    public void remove(JMenuItem jMenuItem) {
        if (this.popupMenu != null) {
            this.popupMenu.remove(jMenuItem);
        }
        this.unregisterMenuItemForAction(jMenuItem);
    }

    public void removeAll() {
        if (this.popupMenu != null) {
            this.popupMenu.removeAll();
        }
        this.clearListenerRegistry();
    }

    public void removeMenuListener(MenuListener menuListener) {
        this.listenerList.remove(class$javax$swing$event$MenuListener != null ? class$javax$swing$event$MenuListener : (class$javax$swing$event$MenuListener = JMenu.class$("javax.swing.event.MenuListener")), menuListener);
    }

    public void setAccelerator(KeyStroke keyStroke) {
        throw new Error("setAccelerator() is not defined for JMenu.  Use setMnemonic() instead.");
    }

    public void setDelay(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Delay must be a positive integer");
        }
        this.delay = n;
    }

    public void setMenuLocation(int n, int n2) {
        if (this.popupMenu != null) {
            this.popupMenu.setLocation(n, n2);
        }
    }

    public void setModel(ButtonModel buttonModel) {
        ButtonModel buttonModel2 = this.getModel();
        super.setModel(buttonModel);
        if (buttonModel2 != null && this.menuChangeListener != null) {
            buttonModel2.removeChangeListener(this.menuChangeListener);
            this.menuChangeListener = null;
        }
        this.model = buttonModel;
        if (buttonModel != null) {
            this.menuChangeListener = this.createMenuChangeListener();
            buttonModel.addChangeListener(this.menuChangeListener);
        }
    }

    public void setPopupMenuVisible(boolean bl) {
        if (!this.isEnabled()) {
            return;
        }
        boolean bl2 = this.isPopupMenuVisible();
        if (bl != bl2) {
            this.ensurePopupMenuCreated();
            if (bl && this.isShowing()) {
                Point point = this.getPopupMenuOrigin();
                this.getPopupMenu().show(this, point.x, point.y);
            } else {
                this.getPopupMenu().setVisible(false);
            }
        }
    }

    public void setSelected(boolean bl) {
        ButtonModel buttonModel = this.getModel();
        boolean bl2 = buttonModel.isSelected();
        if (this.accessibleContext != null && bl2 != bl) {
            if (bl) {
                this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.SELECTED);
            } else {
                this.accessibleContext.firePropertyChange("AccessibleState", AccessibleState.SELECTED, null);
            }
        }
        if (bl != buttonModel.isSelected()) {
            this.getModel().setSelected(bl);
        }
    }

    private Point translateToPopupMenu(int n, int n2) {
        int n3;
        int n4;
        if (this.getParent() instanceof JPopupMenu) {
            n4 = n - this.getSize().width;
            n3 = n2;
        } else {
            n4 = n;
            n3 = n2 - this.getSize().height;
        }
        return new Point(n4, n3);
    }

    private Point translateToPopupMenu(Point point) {
        return this.translateToPopupMenu(point.x, point.y);
    }

    private void unregisterMenuItemForAction(JMenuItem jMenuItem) {
        ActionChangedListener actionChangedListener;
        if (listenerRegistry != null && (actionChangedListener = (ActionChangedListener)listenerRegistry.remove(jMenuItem)) != null) {
            Action action = (Action)listenerRegistry.remove(actionChangedListener);
            if (action != null) {
                jMenuItem.removeActionListener(action);
                action.removePropertyChangeListener(actionChangedListener);
            }
            actionChangedListener.setTarget(null);
        }
    }

    public void updateUI() {
        this.setUI((MenuItemUI)UIManager.getUI(this));
        if (this.popupMenu != null) {
            this.popupMenu.setUI((PopupMenuUI)UIManager.getUI(this.popupMenu));
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.ui != null && this.getUIClassID().equals(uiClassID)) {
            this.ui.installUI(this);
        }
    }

    private class ActionChangedListener
    implements PropertyChangeListener {
        JMenuItem menuItem;

        ActionChangedListener(JMenuItem jMenuItem) {
            this.setTarget(jMenuItem);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (propertyChangeEvent.getPropertyName().equals("Name")) {
                String string2 = (String)propertyChangeEvent.getNewValue();
                this.menuItem.setText(string2);
            } else if (string.equals("enabled")) {
                Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                this.menuItem.setEnabled(bl);
            } else if (propertyChangeEvent.getPropertyName().equals("SmallIcon")) {
                Icon icon = (Icon)propertyChangeEvent.getNewValue();
                this.menuItem.setIcon(icon);
                this.menuItem.invalidate();
                this.menuItem.repaint();
            }
        }

        public void setTarget(JMenuItem jMenuItem) {
            this.menuItem = jMenuItem;
        }
    }

    class MenuChangeListener
    implements ChangeListener,
    Serializable {
        boolean isSelected = false;

        MenuChangeListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            ButtonModel buttonModel = (ButtonModel)changeEvent.getSource();
            boolean bl = buttonModel.isSelected();
            if (bl != this.isSelected) {
                if (bl) {
                    JMenu.this.fireMenuSelected();
                } else {
                    JMenu.this.fireMenuDeselected();
                }
                this.isSelected = bl;
            }
        }
    }

    protected class WinListener
    extends WindowAdapter
    implements Serializable {
        JPopupMenu popupMenu;

        public WinListener(JPopupMenu jPopupMenu) {
            this.popupMenu = jPopupMenu;
        }

        public void windowClosing(WindowEvent windowEvent) {
            JMenu.this.setSelected(false);
        }
    }

    protected class AccessibleJMenu
    extends JMenuItem.AccessibleJMenuItem
    implements AccessibleSelection {
        protected AccessibleJMenu() {
            super(JMenu.this);
        }

        public void addAccessibleSelection(int n) {
            if (n < 0 || n >= JMenu.this.getItemCount()) {
                return;
            }
            JMenuItem jMenuItem = JMenu.this.getItem(n);
            if (jMenuItem != null) {
                if (jMenuItem instanceof JMenu) {
                    MenuElement[] menuElementArray = JMenu.this.buildMenuElementArray((JMenu)jMenuItem);
                    MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray);
                } else {
                    jMenuItem.doClick();
                    MenuSelectionManager.defaultManager().setSelectedPath(null);
                }
            }
        }

        public void clearAccessibleSelection() {
            MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
            if (menuElementArray != null) {
                int n = 0;
                while (n < menuElementArray.length) {
                    if (menuElementArray[n] == JMenu.this) {
                        MenuElement[] menuElementArray2 = new MenuElement[n + 1];
                        System.arraycopy(menuElementArray, 0, menuElementArray2, 0, n);
                        menuElementArray2[n] = JMenu.this.getPopupMenu();
                        MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray2);
                    }
                    ++n;
                }
            }
        }

        public Accessible getAccessibleChild(int n) {
            Component[] componentArray = JMenu.this.getMenuComponents();
            int n2 = 0;
            int n3 = 0;
            while (n3 < componentArray.length) {
                if (componentArray[n3] instanceof Accessible) {
                    if (n2 == n) {
                        if (componentArray[n3] instanceof JComponent) {
                            AccessibleContext accessibleContext = ((Accessible)((Object)componentArray[n3])).getAccessibleContext();
                            accessibleContext.setAccessibleParent(JMenu.this);
                        }
                        return (Accessible)((Object)componentArray[n3]);
                    }
                    ++n2;
                }
                ++n3;
            }
            return null;
        }

        public int getAccessibleChildrenCount() {
            Component[] componentArray = JMenu.this.getMenuComponents();
            int n = 0;
            int n2 = 0;
            while (n2 < componentArray.length) {
                if (componentArray[n2] instanceof Accessible) {
                    ++n;
                }
                ++n2;
            }
            return n;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU;
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        public Accessible getAccessibleSelection(int n) {
            if (n < 0 || n >= JMenu.this.getItemCount()) {
                return null;
            }
            MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
            if (menuElementArray != null) {
                int n2 = 0;
                while (n2 < menuElementArray.length) {
                    if (menuElementArray[n2] == JMenu.this) {
                        while (++n2 < menuElementArray.length) {
                            if (!(menuElementArray[n2] instanceof JMenuItem)) continue;
                            return (Accessible)((Object)menuElementArray[n2]);
                        }
                    }
                    ++n2;
                }
            }
            return null;
        }

        public int getAccessibleSelectionCount() {
            MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
            if (menuElementArray != null) {
                int n = 0;
                while (n < menuElementArray.length) {
                    if (menuElementArray[n] == JMenu.this && n + 1 < menuElementArray.length) {
                        return 1;
                    }
                    ++n;
                }
            }
            return 0;
        }

        public boolean isAccessibleChildSelected(int n) {
            MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
            if (menuElementArray != null) {
                JMenuItem jMenuItem = JMenu.this.getItem(n);
                int n2 = 0;
                while (n2 < menuElementArray.length) {
                    if (menuElementArray[n2] == jMenuItem) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }

        public void removeAccessibleSelection(int n) {
            if (n < 0 || n >= JMenu.this.getItemCount()) {
                return;
            }
            JMenuItem jMenuItem = JMenu.this.getItem(n);
            if (jMenuItem != null && jMenuItem instanceof JMenu && ((JMenu)jMenuItem).isSelected()) {
                MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
                MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length - 1];
                int n2 = 0;
                while (n2 < menuElementArray.length - 1) {
                    menuElementArray2[n2] = menuElementArray[n2];
                    ++n2;
                }
                MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray2);
            }
        }

        public void selectAllAccessibleSelection() {
        }
    }
}

