/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.plaf.metal.BumpBuffer;
import javax.swing.plaf.metal.MetalLookAndFeel;

class MetalBumps
implements Icon {
    protected int xBumps;
    protected int yBumps;
    protected Color topColor = MetalLookAndFeel.getPrimaryControlHighlight();
    protected Color shadowColor = MetalLookAndFeel.getPrimaryControlDarkShadow();
    protected Color backColor = MetalLookAndFeel.getPrimaryControlShadow();
    protected static Vector buffers = new Vector();
    protected BumpBuffer buffer;

    public MetalBumps(int n, int n2) {
        this.setBumpArea(n, n2);
        this.buffer = this.getBuffer(this.topColor, this.shadowColor, this.backColor);
        if (this.buffer == null) {
            this.createBuffer();
        }
    }

    public MetalBumps(int n, int n2, Color color, Color color2, Color color3) {
        this.setBumpArea(n, n2);
        this.setBumpColors(color, color2, color3);
        this.buffer = this.getBuffer(this.topColor, this.shadowColor, this.backColor);
        if (this.buffer == null) {
            this.createBuffer();
        }
    }

    public MetalBumps(Dimension dimension) {
        this(dimension.width, dimension.height);
    }

    protected void createBuffer() {
        this.buffer = new BumpBuffer(this.topColor, this.shadowColor, this.backColor);
        buffers.addElement(this.buffer);
    }

    protected BumpBuffer getBuffer(Color color, Color color2, Color color3) {
        BumpBuffer bumpBuffer = null;
        Enumeration enumeration = buffers.elements();
        while (enumeration.hasMoreElements()) {
            BumpBuffer bumpBuffer2 = (BumpBuffer)enumeration.nextElement();
            if (!bumpBuffer2.hasSameColors(color, color2, color3)) continue;
            bumpBuffer = bumpBuffer2;
            break;
        }
        return bumpBuffer;
    }

    public int getIconHeight() {
        return this.yBumps * 2;
    }

    public int getIconWidth() {
        return this.xBumps * 2;
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        int n3 = this.buffer.getImageSize().width;
        int n4 = this.buffer.getImageSize().height;
        int n5 = this.getIconWidth();
        int n6 = this.getIconHeight();
        int n7 = n + n5;
        int n8 = n2 + n6;
        int n9 = n;
        while (n2 < n8) {
            int n10 = Math.min(n8 - n2, n4);
            n = n9;
            while (n < n7) {
                int n11 = Math.min(n7 - n, n3);
                graphics.drawImage(this.buffer.getImage(), n, n2, n + n11, n2 + n10, 0, 0, n11, n10, null);
                n += n3;
            }
            n2 += n4;
        }
    }

    public void setBumpArea(int n, int n2) {
        this.xBumps = n / 2;
        this.yBumps = n2 / 2;
    }

    public void setBumpArea(Dimension dimension) {
        this.setBumpArea(dimension.width, dimension.height);
    }

    public void setBumpColors(Color color, Color color2, Color color3) {
        this.topColor = color;
        this.shadowColor = color2;
        this.backColor = color3;
        this.buffer = this.getBuffer(this.topColor, this.shadowColor, this.backColor);
        if (this.buffer == null) {
            this.createBuffer();
        }
    }
}

