/*
 * Decompiled with CFR 0.152.
 */
package viewer.zoomable;

import base.drawable.ColorAlpha;
import base.drawable.Drawable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import javax.swing.BoundedRangeModel;
import javax.swing.SwingUtilities;
import viewer.common.Dialogs;
import viewer.common.Parameters;
import viewer.zoomable.Debug;
import viewer.zoomable.InfoDialog;
import viewer.zoomable.ModelTime;
import viewer.zoomable.SearchDialog;
import viewer.zoomable.SearchPanel;
import viewer.zoomable.SearchableView;
import viewer.zoomable.ViewportTime;
import viewer.zoomable.YaxisTree;

public class ViewportTimeYaxis
extends ViewportTime
implements AdjustmentListener {
    private static final Color SEARCH_LINE_COLOR = Color.yellow;
    private static final int SEARCH_ARROW_HALF_ANGLE = 15;
    private static final double SEARCH_ARROW_ANGLE = 0.5235987755982988;
    private static final double COS_SEARCH_ARROW_ANGLE = Math.cos(0.5235987755982988);
    private static final double SIN_SEARCH_ARROW_ANGLE = Math.sin(0.5235987755982988);
    private ModelTime time_model = null;
    private BoundedRangeModel y_model = null;
    private YaxisTree tree_view = null;
    private Point view_pt = null;
    private ComponentEvent resize_evt = null;
    private SearchableView searchable = null;
    private SearchDialog search_dialog = null;
    private Drawable searched_dobj = null;
    private double searching_time;
    private static final double INVALID_TIME = Double.NEGATIVE_INFINITY;
    private double searched_time = Double.NEGATIVE_INFINITY;
    private int mouse_last_Yloc;
    private double ratio_ymodel2vportH;

    public ViewportTimeYaxis(ModelTime modelTime, BoundedRangeModel boundedRangeModel, YaxisTree yaxisTree) {
        super(modelTime);
        this.time_model = modelTime;
        this.y_model = boundedRangeModel;
        this.tree_view = yaxisTree;
        this.view_pt = new Point(0, 0);
        this.resize_evt = new ComponentEvent(this, 101);
        this.searching_time = this.time_model.getTimeGlobalMinimum();
    }

    public void setView(Component component) {
        super.setView(component);
        this.searchable = component instanceof SearchableView ? (SearchableView)((Object)component) : null;
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (Debug.isActive()) {
            Debug.println("ViewportTimeYaxis: adjChanged()'s START: ");
            Debug.println("adj_evt = " + adjustmentEvent);
        }
        this.view_pt.x = super.getXaxisViewPosition();
        this.view_pt.y = adjustmentEvent.getValue();
        super.setYaxisViewPosition(this.view_pt.y);
        super.setViewPosition(this.view_pt);
        super.repaint();
        if (Debug.isActive()) {
            Debug.println("ViewportTimeYaxis: adjChanged()'s END: ");
        }
    }

    public void fireComponentResized() {
        super.componentResized(this.resize_evt);
    }

    private Rectangle localRectangleForDrawable(Drawable drawable) {
        Rectangle rectangle = this.searchable.localRectangleForDrawable(drawable);
        Point point = SwingUtilities.convertPoint((Component)((Object)this.searchable), rectangle.x, rectangle.y, this);
        rectangle.setLocation(point);
        return rectangle;
    }

    private void drawMarkerForSearchedDrawable(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = this.getWidth();
        int n7 = this.getHeight();
        Rectangle rectangle = this.localRectangleForDrawable(this.searched_dobj);
        if (rectangle.x >= 0 && rectangle.x < n6) {
            ColorAlpha colorAlpha = this.searched_dobj.getCategory().getColor();
            Color color = colorAlpha.brighter();
            Color color2 = colorAlpha.darker();
            n5 = Parameters.SEARCH_FRAME_THICKNESS;
            int n8 = Parameters.SEARCH_ARROW_LENGTH;
            int n9 = 2 * n8;
            int n10 = (int)((double)n8 * SIN_SEARCH_ARROW_ANGLE + 0.5);
            int n11 = (int)((double)n8 * COS_SEARCH_ARROW_ANGLE + 0.5);
            n4 = rectangle.x;
            n3 = rectangle.y - n5;
            graphics.setColor(colorAlpha);
            graphics.fillArc(n4 - n8, n3 - n8, n9, n9, 90, -15);
            graphics.setColor(color2);
            graphics.fillArc(n4 - n8, n3 - n8, n9, n9, 75, -15);
            graphics.setColor(color);
            graphics.drawLine(n4, n3, n4, n3 - n8);
            graphics.setColor(color);
            graphics.drawLine(n4, n3, n4 + n10, n3 - n11);
            n2 = n4;
            n = rectangle.y + rectangle.height + n5;
            graphics.setColor(Color.yellow);
            graphics.fillArc(n2 - n8, n - n8, n9, n9, 270, 15);
            graphics.setColor(Color.darkGray);
            graphics.fillArc(n2 - n8, n - n8, n9, n9, 285, 15);
            graphics.setColor(Color.gray);
            graphics.drawLine(n2, n, n2, n + n8);
            graphics.setColor(Color.white);
            graphics.drawLine(n2, n, n2 + n10, n + n11);
        }
        rectangle = SwingUtilities.computeIntersection(0, 0, n6, n7, rectangle);
        if (rectangle.x >= 0) {
            if (Parameters.SEARCHED_OBJECT_ON_TOP) {
                graphics.setColor(this.searched_dobj.getCategory().getColor());
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            n5 = Parameters.SEARCH_FRAME_THICKNESS;
            n4 = rectangle.x;
            n3 = rectangle.y;
            n2 = n4 + rectangle.width;
            n = n3 + rectangle.height;
            graphics.setColor(Color.black);
            int n12 = 0;
            graphics.drawLine(n4 - n12, n3 - n12, n4 - n12, n + n12);
            graphics.drawLine(n4 - n12, n3 - n12, n2 + n12, n3 - n12);
            graphics.setColor(Color.white);
            for (n12 = 1; n12 <= n5; ++n12) {
                graphics.drawLine(n4 - n12, n3 - n12, n4 - n12, n + n12);
                graphics.drawLine(n4 - n12, n3 - n12, n2 + n12, n3 - n12);
            }
            graphics.setColor(Color.white);
            n12 = 0;
            graphics.drawLine(n2 + n12, n3 - n12, n2 + n12, n + n12);
            graphics.drawLine(n4 - n12, n + n12, n2 + n12, n + n12);
            graphics.setColor(Color.darkGray);
            for (n12 = 1; n12 <= n5; ++n12) {
                graphics.drawLine(n2 + n12, n3 - n12, n2 + n12, n + n12);
                graphics.drawLine(n4 - n12, n + n12, n2 + n12, n + n12);
            }
        }
    }

    public void paint(Graphics graphics) {
        if (Debug.isActive()) {
            Debug.println("ViewportTimeYaxis: paint()'s START: ");
        }
        super.paint(graphics);
        if (this.coord_xform.contains(this.searching_time)) {
            int n = this.coord_xform.convertTimeToPixel(this.searching_time);
            graphics.setColor(SEARCH_LINE_COLOR);
            graphics.drawLine(n, 0, n, this.getHeight());
        }
        if (this.searched_dobj != null) {
            this.drawMarkerForSearchedDrawable(graphics);
        }
        if (Debug.isActive()) {
            Debug.println("ViewportTimeYaxis: paint()'s END: ");
        }
    }

    public void eraseSearchedDrawable() {
        this.searched_dobj = null;
    }

    public boolean searchBackward() {
        SearchPanel searchPanel = null;
        if (this.search_dialog == null) {
            Window window = SwingUtilities.windowForComponent(this);
            if (window instanceof Frame) {
                this.search_dialog = new SearchDialog((Frame)window, this);
            } else {
                Dialogs.error(window, "ViewportTimeYaxis.searchBackward() is meant to be invoked from a top JFrame.");
            }
        }
        if ((searchPanel = this.searching_time != this.searched_time ? this.searchable.searchPreviousComponent(this.searching_time) : this.searchable.searchPreviousComponent()) != null) {
            this.searched_dobj = searchPanel.getSearchedDrawable();
            this.searched_time = this.searched_dobj.getEarliestTime();
            this.time_model.scroll(this.searched_time - this.searching_time);
            this.searching_time = this.searched_time;
            this.tree_view.scrollRowToVisible(this.searched_dobj.getRowID());
            this.repaint();
            this.search_dialog.replace(searchPanel);
            if (!this.search_dialog.isVisible()) {
                this.search_dialog.setVisibleAtDefaultLocation();
            }
            return true;
        }
        if (this.searched_dobj != null && this.searched_dobj.getEarliestTime() == this.time_model.getTimeGlobalMinimum()) {
            Dialogs.info(SwingUtilities.windowForComponent(this), "The FIRST drawable in the logfile has been reached.\n  Search backward has no more drawable to return.\n", null);
        } else {
            Dialogs.warn(SwingUtilities.windowForComponent(this), "If the logfile's beginning is not within view,\nSCROLL BACKWARD till you see more drawables\nare within view.  All drawables in view or in \nthe memory have been searched.\n");
        }
        this.search_dialog.setVisible(false);
        this.searched_dobj = null;
        this.searched_time = Double.NEGATIVE_INFINITY;
        this.repaint();
        return false;
    }

    public boolean searchForward() {
        SearchPanel searchPanel = null;
        if (this.search_dialog == null) {
            Window window = SwingUtilities.windowForComponent(this);
            if (window instanceof Frame) {
                this.search_dialog = new SearchDialog((Frame)window, this);
            } else {
                Dialogs.error(window, "ViewportTimeYaxis.searchForward() is meant to be invoked from a top JFrame.");
            }
        }
        if ((searchPanel = this.searching_time != this.searched_time ? this.searchable.searchNextComponent(this.searching_time) : this.searchable.searchNextComponent()) != null) {
            this.searched_dobj = searchPanel.getSearchedDrawable();
            this.searched_time = this.searched_dobj.getEarliestTime();
            this.time_model.scroll(this.searched_time - this.searching_time);
            this.searching_time = this.searched_time;
            this.tree_view.scrollRowToVisible(this.searched_dobj.getRowID());
            this.repaint();
            this.search_dialog.replace(searchPanel);
            if (!this.search_dialog.isVisible()) {
                this.search_dialog.setVisibleAtDefaultLocation();
            }
            return true;
        }
        if (this.searched_dobj != null && this.searched_dobj.getLatestTime() == this.time_model.getTimeGlobalMaximum()) {
            Dialogs.info(SwingUtilities.windowForComponent(this), "The LAST drawable in the logfile has been reached.\n  Search forward has no more drawable to return.\n", null);
        } else {
            Dialogs.warn(SwingUtilities.windowForComponent(this), "If the end of the logfile is not within view,\nSCROLL FORWARD till you see more drawables\nare within view.  All drawables in view or in \nthe memory have been searched.\n");
        }
        this.search_dialog.setVisible(false);
        this.searched_dobj = null;
        this.searched_time = Double.NEGATIVE_INFINITY;
        this.repaint();
        return false;
    }

    public boolean searchInit() {
        InfoDialog infoDialog = super.getLastInfoDialog();
        if (infoDialog != null) {
            this.searching_time = infoDialog.getClickedTime();
            infoDialog.getCloseButton().doClick();
            this.repaint();
            return true;
        }
        Dialogs.warn(SwingUtilities.windowForComponent(this), "No info dialog box! Info dialog box can be set\nby right mouse clicking on the timeline canvas\n");
        return false;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        super.mouseClicked(mouseEvent);
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && !this.isLeftMouseClick4Zoom) {
            Point point = mouseEvent.getPoint();
            this.searching_time = this.coord_xform.convertPixelToTime(point.x);
            this.repaint();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && !this.isLeftMouseClick4Zoom) {
            Point point = mouseEvent.getPoint();
            this.mouse_last_Yloc = point.y;
            this.ratio_ymodel2vportH = (double)this.y_model.getExtent() / (double)this.getHeight();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        super.mouseDragged(mouseEvent);
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && !this.isLeftMouseClick4Zoom) {
            Point point = mouseEvent.getPoint();
            int n = this.mouse_last_Yloc - point.y;
            int n2 = (int)Math.round(this.ratio_ymodel2vportH * (double)n);
            this.y_model.setValue(this.y_model.getValue() + n2);
            this.mouse_last_Yloc = point.y;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        super.mouseReleased(mouseEvent);
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && !this.isLeftMouseClick4Zoom) {
            Point point = mouseEvent.getPoint();
            int n = this.mouse_last_Yloc - point.y;
            int n2 = (int)Math.round(this.ratio_ymodel2vportH * (double)n);
            this.y_model.setValue(this.y_model.getValue() + n2);
            this.mouse_last_Yloc = point.y;
        }
    }
}

