#include <iostream>
#include <algorithm>
#include <string>
#include <vector>

#include <wx/string.h>

#include "BasicVolumeFormat.h"

using namespace jcs;
using namespace std;

BasicVolumeFormat::BasicVolumeFormat(const char* filename, 
		const char* header_extension,
		const char* raw_extension) 
	: mFileName(wxString(filename, wxConvLocal)), 
	  mHeaderExtension(wxString(header_extension, wxConvLocal)), 
	  mRawExtension(wxString(raw_extension, wxConvLocal))
{
	wxFileName::Mkdir(mFileName.GetPath(wxPATH_GET_VOLUME), 0777, wxPATH_MKDIR_FULL);
}

BasicVolumeFormat::~BasicVolumeFormat()
{
	if (mHeaderFile.is_open()) mCloseHeaderFile();
	if (mRawDataFile.is_open()) mCloseRawDataFile();
}


int
BasicVolumeFormat::mOpenHeaderFile(std::ios::openmode mode) 
{
	if (!mFileName.IsOk()) return 0;
	if (mHeaderFile.is_open()) mHeaderFile.close();
	mHeaderFile.clear();

	mFileName.SetExt(mHeaderExtension);

	std::string filename(mFileName.GetFullPath().mb_str(wxConvLocal));
	mHeaderFile.open(filename.c_str(), mode);

//	mHeaderFile.open(mFileName.GetFullPath().mb_str(wxConvLocal), mode);

	return mHeaderFile.good();
}

/*
int
BasicVolumeFormat::mOpenRawDataFile(std::ios::openmode mode)
{
	if (!mFileName.IsOk()) return 0;
	if (mRawDataFile.is_open()) mRawDataFile.close();
	mRawDataFile.clear();
//	std::string filename = mFileName;
//	filename.append(mRawExtension);
	mFileName.SetExt(mRawExtension);
	mRawDataFile.open(mFileName.GetFullPath().c_str(), mode);
	return mRawDataFile.good();
}
*/

int
BasicVolumeFormat::AppendRawData(char* data, size_t n_bytes)
{
/*	if (!mRawDataFile.is_open()) {
		if(!mOpenRawDataFile(ios::out|ios::app|ios::binary)) return 0;
	}

	mRawDataFile.write(data, n_bytes);
*/

	if (mRawExtension != _T(""))
		mFileName.SetExt(mRawExtension);
	else
		mFileName.SetExt(mHeaderExtension);

	if (!mFileName.IsOk()) return 0;

	if (!mRawDataFile.is_open()) {
		if (mRawExtension != _T("")) {
			mRawDataFile.clear();
			mRawDataFile.open(mFileName.GetFullPath().mb_str(wxConvLocal), ios::out|ios::trunc|ios::binary);
		}
		else {
			mRawDataFile.open(mFileName.GetFullPath().mb_str(wxConvLocal), ios::out|ios::app|ios::binary);
		}
	}

	if (!mRawDataFile.good()) return 0;
	mRawDataFile.write(data, n_bytes);

	return 1;
}
