#define _CRT_SECURE_NO_WARNINGS

#pragma warning(disable: 4996)


#include <string>
#include <vector>

#include "SeriesHandler.h"
#include "NiftiVolume.h"
#include "FslNiftiOutputter.h"

using namespace std;
using namespace jcs;

FslNiftiOutputter::FslNiftiOutputter() : 
NiftiOutputterBase(CreateOptions())
{
}

Options
FslNiftiOutputter::CreateOptions()
{
  Options options = Get3DOptions();
  options.pathname = "FslNifti";
  return options;
}

void
FslNiftiOutputter::UpdateOutputForSeries(SeriesHandler* handler)
{
  Basic3DOutputter::UpdateOutputForSeries(handler);

  // if is DTI
  if (handler->IsDti()) {
    string series_uid(handler->GetSeriesUid());
    ImageFileName name;
    name.seriesUid = series_uid;
    name.SetPrefix(GenerateDefaultPrefix(handler));
    FillInDefaultDirs(name, handler);
    name.SetExt("");
    name.SetPostfix("_bvecs");
    mOutputList.fileNameList.insert(make_pair(series_uid+"_bvecs", name));
    name.SetPostfix("_bvals");
    mOutputList.fileNameList.insert(make_pair(series_uid+"_bvals", name));
  }

}

int
FslNiftiOutputter::ConvertSeries(SeriesHandler* handler)
{
  int bits_allocated, pixel_rep = 0;
  handler->Find("BitsAllocated", bits_allocated);
  handler->Find("PixelRepresentation", pixel_rep);

  switch (bits_allocated + pixel_rep) {

    case 9 : {
      FslNiftiConversion<wxInt8> conversion(this, handler);
      conversion.Convert();
      break;
    }
    case 8 : {
      FslNiftiConversion<wxUint8> conversion(this, handler);
      conversion.Convert();
      break;
    }
    case 17 : {
      FslNiftiConversion<wxInt16> conversion(this, handler);
      conversion.Convert();
      break;
    }
    case 16 :
    default : {
      FslNiftiConversion<wxUint16> conversion(this, handler);
      conversion.Convert();
      break;
    }
  }

  return 1;
}



