#include "OutputValidator.h"

using namespace jcs;

BEGIN_EVENT_TABLE(OverwriteDlg, wxDialog)

	EVT_BUTTON(wxID_YES,		OverwriteDlg::OnButton)
	EVT_BUTTON(wxID_YESTOALL,	OverwriteDlg::OnButton)
	EVT_BUTTON(wxID_NO,			OverwriteDlg::OnButton)
	EVT_BUTTON(wxID_CANCEL,		OverwriteDlg::OnButton)

END_EVENT_TABLE()

OverwriteDlg::OverwriteDlg(wxWindow* parent, const char* filename):
: wxDialog(parent, -1, "Confirm file overwrite")
{
	wxBoxSizer* dlgSizer = new wxBoxSizer(wxVERTICAL);

// if we add this back, might not be ok in unicode -- check
	wxString message = wxString::Format("%s exists. Overwrite?", filename);
	dlgSizer->Add(new wxStaticText(message));

	wxBoxSizer* buttonSizer = new wxBoxSizer(wxHORIZONTAL);

	buttonSizer->Add(new wxButton(this, wxID_YES, "Yes"));
	buttonSizer->Add(new wxButton(this, wxID_YESTOALL, "Yes to All"));
	buttonSizer->Add(new wxButton(this, wxID_NO, "No"));
	buttonSizer->Add(new wxButton(this, wxID_CANCEL, "Cancel"));

	dlgSizer->Add(buttonSizer);

	SetSizer(dlgSizer);
	dlgSizer->Fit(this);

}

void
OverwriteDlg::OnButton(wxCommandEvent& event)
{
	EndModal(event.GetId());
}

OutputValidator::OutputValidator()
{
	mOverwriteAll = false;
}

int
OutputValidator::Validate(const char* filename)
{
	if (mOverwriteAll) return wxID_YES;

	if (wxFile::Exists(filename)) {
		OverwriteDlg* odlg = new OverwriteDlg(filename);
		int choice = odlg->ShowModal();
		odlg->Destroy();
		if (choice == wxID_YESTOALL) {
			mOverwriteAll = true;
			return wxID_YES;
		}
		else return choice;
	}

	else return wxID_YES;


}