/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2001 Thomas Nyberg <thomas@codefactory.se>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Thomas Nyberg
 */
#ifndef __MONTH_VIEW_SUMMARY_TASK_ITEM_H__
#define __MONTH_VIEW_SUMMARY_TASK_ITEM_H__


#include <glib.h>
#include <libgnomeui/gnome-canvas.h>
#include "month-view-task-item.h"

#define MONTH_VIEW_SUMMARY_TASK_ITEM_TYPE          month_view_summary_task_item_get_type ()
#define MONTH_VIEW_SUMMARY_TASK_ITEM(obj)          GTK_CHECK_CAST (obj, MONTH_VIEW_SUMMARY_TASK_ITEM_TYPE, MonthViewSummaryTaskItem)
#define MONTH_VIEW_SUMMARY_TASK_ITEM_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, MONTH_VIEW_SUMMARY_TASK_ITEM_TYPE, MonthViewSummaryTaskItemClass)
#define IS_MONTH_VIEW_SUMMARY_TASK_ITEM(obj)       GTK_CHECK_TYPE (obj, MONTH_VIEW_SUMMARY_TASK_ITEM_TYPE)


typedef struct _MonthViewSummaryTaskItem MonthViewSummaryTaskItem;
typedef struct _MonthViewSummaryTaskItemClass MonthViewSummaryTaskItemClass;

struct _MonthViewSummaryTaskItem {
	MonthViewTaskItem parent;
};

struct _MonthViewSummaryTaskItemClass {
	MonthViewTaskItemClass parent_class;
};


GtkType month_view_summary_task_item_get_type (void);

#endif /* __MONTH_VIEW_SUMMARY_TASK_ITEM_H__ */
