/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2001 Thomas Nyberg <thomas@codefactory.se>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Thomas Nyberg
 */
#ifndef __RESOURCE_FILTER_DIALOG_GUI_H__
#define __RESOURCE_FILTER_DIALOG_GUI_H__

#include <glib.h>
#include <gtk/gtktypeutils.h>
#include <gtk/gtkwidget.h>
#include <gtk/gtkwindow.h>
#include "util/corba-utils.h"
#include "libmrproject/GNOME_MrProject.h"

#define RESOURCE_FILTER_DIALOG_GUI_TYPE         (resource_filter_dialog_gui_get_type ())
#define RESOURCE_FILTER_DIALOG_GUI(o)           (GTK_CHECK_CAST ((o), RESOURCE_FILTER_DIALOG_GUI_TYPE, ResourceFilterDialogGui))
#define RESOURCE_FILTER_DIALOG_GUI_CLASS(k)     (GTK_CHECK_CLASS_CAST ((k), RESOURCE_FILTER_DIALOG_GUI_TYPE, ResourceFilterDialogGuiClass))
#define IS_RESOURCE_FILTER_DIALOG_GUI(o)        (GTK_CHECK_TYPE ((o), RESOURCE_FILTER_DIALOG_GUI_TYPE))
#define IS_RESOURCE_FILTER_DIALOG_GUI_CLASS(k)  (GTK_CHECK_CLASS_TYPE ((k), RESOURCE_FILTER_DIALOG_GUI_TYPE))

typedef struct _ResourceFilterDialogGui ResourceFilterDialogGui;
typedef struct _ResourceFilterDialogGuiClass ResourceFilterDialogGuiClass;
typedef struct _ResourceFilterDialogGuiPriv ResourceFilterDialogGuiPriv;

struct _ResourceFilterDialogGui {
	GtkWindow parent;

	ResourceFilterDialogGuiPriv *priv;
};

struct _ResourceFilterDialogGuiClass {
	GtkWindowClass parent_class;

	void (*resource_checked) (ResourceFilterDialogGui *gui, 
				  GM_Id id);
	void (*resource_unchecked) (ResourceFilterDialogGui *gui, 
				    GM_Id id);
	/* filter is a list of selected resources */
	void (*apply_filter) (ResourceFilterDialogGui *gui, 
			      GSList *filter); 
	void (*clear_filter) (ResourceFilterDialogGui *gui);
};

GtkType resource_filter_dialog_gui_get_type (void);
GtkWidget *resource_filter_dialog_gui_new (void);

void resource_filter_dialog_gui_add_resource    (ResourceFilterDialogGui *gui, 
						 GM_Resource             *resource,
						 gboolean                 selected);
void resource_filter_dialog_gui_remove_resource (ResourceFilterDialogGui *gui, 
						 GM_Id                    id);
/* used to avoid mass-updates of the tables */
void resource_filter_dialog_gui_add_resources (ResourceFilterDialogGui   *gui,
					       GSList                    *resources);
void resource_filter_dialog_gui_update_resource (ResourceFilterDialogGui *gui,
						 GM_Resource             *resource);

#endif /* __RESOURCE_FILTER_DIALOG_GUI_H__ */

