/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2001 CodeFactory AB
 * Copyright (C) 2001 Richard Hult <rhult@codefactory.se>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author:  Richard Hult <rhult@codefactory.se>
 */

#ifndef __GANTT_PRINTABLE_H__
#define __GANTT_PRINTABLE_H__

#include <time.h>
#include <gtk/gtktypeutils.h>
#include <gtk/gtkobject.h>
#include "gantt-print-info.h"

#define TYPE_GANTT_PRINTABLE			(gantt_printable_get_type ())
#define GANTT_PRINTABLE(obj)			(GTK_CHECK_CAST ((obj), TYPE_GANTT_PRINTABLE, GanttPrintable))
#define GANTT_PRINTABLE_CLASS(klass)		(GTK_CHECK_CLASS_CAST ((klass), TYPE_GANTT_PRINTABLE, GanttPrintableClass))
#define IS_GANTT_PRINTABLE(obj)			(GTK_CHECK_TYPE ((obj), TYPE_GANTT_PRINTABLE))
#define IS_GANTT_PRINTABLE_CLASS(klass)		(GTK_CHECK_CLASS_TYPE ((obj), TYPE_GANTT_PRINTABLE))


typedef struct _GanttPrintable       GanttPrintable;
typedef struct _GanttPrintableClass  GanttPrintableClass;

struct _GanttPrintable
{
	GtkObject   parent;
};

struct _GanttPrintableClass
{
	GtkObjectClass parent_class;

	/* Signals. */
	void (* get_width) (GanttPrintable    *printable,
			    GanttPrintInfo    *print_info);

	void (* get_height) (GanttPrintable    *printable,
			     GanttPrintInfo    *print_info);

	void (* get_row_height) (GanttPrintable    *printable,
				 GanttPrintInfo    *print_info);
	
	void (* print_page) (GanttPrintable    *printable,
			     GanttPrintInfo    *print_info,       
			     ArtDRect          *bbox,
			     gdouble            hscale,
			     gdouble            vscale,
			     time_t             t1,
			     time_t             t2,
			     gint               r1,
			     gint               r2);
};


GtkType         gantt_printable_get_type   (void);

GanttPrintable *gantt_printable_new        (void);

gdouble         gantt_printable_get_width  (GanttPrintable    *printable,
					    GanttPrintInfo    *print_info,
					    time_t             from_time,
					    time_t             to_time);

gdouble         gantt_printable_get_height (GanttPrintable    *printable,
					    GanttPrintInfo    *print_info);

gdouble         gantt_printable_get_row_height (GanttPrintable    *printable,
						GanttPrintInfo    *print_info);

void            gantt_printable_print_page (GanttPrintable    *printable,
					    GanttPrintInfo    *print_info,
					    ArtDRect          *bbox,
					    gdouble            hscale,
					    gdouble            vscale,
					    time_t             t1,
					    time_t             t2,
					    gint               r1,
					    gint               r2);



#endif /* __GANTT_PRINTABLE_H__ */

