/*
 * Copyright (C) 2001  CodeFactory AB
 * Copyright (C) 2001  Richard Hult
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Richard Hult <rhult@codefactory.se>
 *         Mikael Hallendal <micke@codefactory.se>
 */
#ifndef __TASK_BOX_H__
#define __TASK_BOX_H__

#include <gtk/gtk.h>
#include <libgnomeui/gnome-canvas.h>
#include "network-canvas.h"
#include "network-item.h"


#define TYPE_TASK_BOX			(task_box_get_type ())
#define TASK_BOX(obj)			(GTK_CHECK_CAST ((obj), TYPE_TASK_BOX, TaskBox))
#define TASK_BOX_CLASS(klass)		(GTK_CHECK_CLASS_CAST ((klass), TYPE_TASK_BOX, TaskBoxClass))
#define IS_TASK_BOX(obj)		(GTK_CHECK_TYPE ((obj), TYPE_TASK_BOX))
#define IS_TASK_BOX_CLASS(klass)	(GTK_CHECK_CLASS_TYPE ((obj), TYPE_TASK_BOX))

typedef struct _TaskBox       TaskBox;
typedef struct _TaskBoxClass  TaskBoxClass;
typedef struct _TaskBoxPriv   TaskBoxPriv;

struct _TaskBox {
	NetworkItem     parent;
	TaskBoxPriv *priv;
};

struct _TaskBoxClass {
	NetworkItemClass parent_class;
};

#define PAD 20.0
#define SMALL_PAD 5.0

GtkType    task_box_get_type     (void);
void       task_box_add_child    (TaskBox           *parent_box,
				  NetworkItem       *child,
				  gint               index);
gint       task_box_remove_child (TaskBox           *parent_box,
				  NetworkItem       *child);
void       task_box_reparent     (TaskBox           *parent_box,
				  TaskBox           *box);


#endif /* __TASK_BOX_H__ */

