/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2001 Richard Hult  <rhult@codefactory.se>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Richard Hult
 */

#ifndef __PYTHON_COMPONENT_H__
#define __PYTHON_COMPONENT_H__

#include <gtk/gtktypeutils.h>
#include "client/components/shell-component/shell-component.h"

#define PYTHON_COMPONENT_TYPE        (python_component_get_type ())
#define PYTHON_COMPONENT(o)          (GTK_CHECK_CAST ((o), PYTHON_COMPONENT_TYPE, PythonComponent))
#define PYTHON_COMPONENT_CLASS(k)    (GTK_CHECK_CLASS_CAST((k), PYTHON_COMPONENT_TYPE, PythonComponentClass))
#define IS_PYTHON_COMPONENT(o)       (GTK_CHECK_TYPE ((o), PYTHON_COMPONENT_TYPE))
#define IS_PYTHON_COMPONENT_CLASS(k) (GTK_CHECK_CLASS_TYPE ((k), PYTHON_COMPONENT_TYPE))

typedef struct _PythonComponentPriv PythonComponentPriv;

typedef struct {
	ShellComponent       parent;
	PythonComponentPriv *priv;
} PythonComponent;

typedef struct {
	ShellComponentClass  parent_class;
} PythonComponentClass;


GtkType  python_component_get_type  (void);


#endif /* _PYTHON_COMPONENT_H_ */

