/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2001 CodeFactory AB
 * Copyright (C) 2001 Anders Carlsson <andersca@codefactory.se>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Anders Carlsson
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <sys/time.h>
#include <unistd.h>
#include <locale.h>
#include <glib.h>
#include <gdk/gdkkeysyms.h>
#include <libgnome/gnome-defs.h>
#include <libgnome/gnome-i18n.h>
#include <gal/util/e-util.h>
#include <gal/e-table/e-cell.h>
#include <gal/e-table/e-cell-text.h>
#include <gal/e-table/e-table-item.h>
#include "util/type-utils.h"
#include "util/time-utils.h"
#include "m-cell-multi-pixbuf.h"

static void m_cell_multi_pixbuf_class_init        (GtkObjectClass *object_class);
static void m_cell_multi_pixbuf_init              (GtkObject      *object);


GNOME_CLASS_BOILERPLATE (MCellMultiPixbuf, m_cell_multi_pixbuf, ECell, e_cell);

typedef struct {
	ECellView    cell_view;
	GdkGC       *gc;
	GnomeCanvas *canvas;
} MCellMultiPixbufView;

static ECellView *
m_cell_multi_pixbuf_new_view (ECell *ecell, ETableModel *table_model, void *e_table_item_view)
{
	MCellMultiPixbufView *multi_pixbuf_view = g_new0 (MCellMultiPixbufView, 1);
	ETableItem *eti = E_TABLE_ITEM (e_table_item_view);
	GnomeCanvas *canvas = GNOME_CANVAS_ITEM (eti)->canvas;
	
	multi_pixbuf_view->cell_view.ecell = ecell;
	multi_pixbuf_view->cell_view.e_table_model = table_model;
	multi_pixbuf_view->cell_view.e_table_item_view = e_table_item_view;
	multi_pixbuf_view->canvas = canvas;
	
	return (ECellView *) multi_pixbuf_view;

}


static gint
m_cell_multi_pixbuf_event (ECellView *ecell_view, GdkEvent *event,
			   int model_col, int view_col, int row,
			   ECellFlags flags, ECellActions *actions)
{
    /* noop */

    return FALSE;
}

static gint
m_cell_multi_pixbuf_height (ECellView *cell_view, gint model_col, gint view_col, gint row)
{
	MCellMultiPixbuf *cell = M_CELL_MULTI_PIXBUF (cell_view->ecell);

	return cell->height + 2;
}

static gint
m_cell_multi_pixbuf_max_width (ECellView *ecell_view, int model_col, int view_col)
{
	MCellMultiPixbuf *cell = M_CELL_MULTI_PIXBUF (ecell_view->ecell);
	gint max_width = 0;
	gint i;
	
	/* FIXME: Make this a little bit more sophisticated */

	for (i = 0; i < cell->n_images; i++) {
		max_width += gdk_pixbuf_get_width (cell->images[i]);
	}

	return max_width;
}

static void
m_cell_multi_pixbuf_draw (ECellView *ecell_view, GdkDrawable *drawable,
			  int model_col, int view_col, int row, ECellFlags flags,
			  int x1, int y1, int x2, int y2)
{
	MCellMultiPixbuf *cell = M_CELL_MULTI_PIXBUF (ecell_view->ecell);
//	MCellMultiPixbufView *multi_pixbuf_view = (MCellMultiPixbufView *) ecell_view;

	const gint value = GPOINTER_TO_INT (e_table_model_value_at (ecell_view->e_table_model, model_col, row));
	gint i;
	gint x = x1;
	
	for (i = 0; i < cell->n_images; i++) {
		if (value & (1 << i)) {
			if (x + gdk_pixbuf_get_width (cell->images[i]) + 1 > x2)
				break;
			
			gdk_pixbuf_render_to_drawable_alpha (cell->images[i], drawable,
							     0, 0,
							     x + 1, y1 + 1,
							     gdk_pixbuf_get_width (cell->images[i]),
							     gdk_pixbuf_get_height (cell->images[i]),
							     GDK_PIXBUF_ALPHA_BILEVEL,
							     128,
							     GDK_RGB_DITHER_NORMAL,
							     0, 0);
			x += gdk_pixbuf_get_width (cell->images[i]) + 1;
			
		}
	}
}

static void
m_cell_multi_pixbuf_destroy (GtkObject *object)
{
	MCellMultiPixbuf *cell = M_CELL_MULTI_PIXBUF (object);
	gint i;
	
	for (i = 0; i < cell->n_images; i++) {
		gdk_pixbuf_unref (cell->images[i]);
	}

	g_free (cell->images);
}

static void
m_cell_multi_pixbuf_realize (ECellView *ecell_view)
{
	MCellMultiPixbufView *multi_pixbuf_view = (MCellMultiPixbufView *) ecell_view;
	
	multi_pixbuf_view->gc = gdk_gc_new (GTK_WIDGET (multi_pixbuf_view->canvas)->window);
}

static void
m_cell_multi_pixbuf_class_init (GtkObjectClass *object_class)
{
	ECellClass *ecc = (ECellClass *) object_class;

	object_class->destroy = m_cell_multi_pixbuf_destroy;
		
	ecc->new_view  = m_cell_multi_pixbuf_new_view;
	ecc->realize   = m_cell_multi_pixbuf_realize;
	ecc->draw      = m_cell_multi_pixbuf_draw;
	ecc->height    = m_cell_multi_pixbuf_height;
	ecc->max_width = m_cell_multi_pixbuf_max_width;
	ecc->event     = m_cell_multi_pixbuf_event;
}

static void
m_cell_multi_pixbuf_init (GtkObject *object)
{
//	MCellMultiPixbuf *cell = M_CELL_MULTI_PIXBUF (object);

	
}

ECell *
m_cell_multi_pixbuf_new (gint n_images, GdkPixbuf **images)
{
	MCellMultiPixbuf *cell = gtk_type_new (m_cell_multi_pixbuf_get_type ());
	gint i;
	gint max_height = 0;

	g_return_val_if_fail (n_images <= 32, NULL);
	
	cell->n_images = n_images;
	cell->images = g_new (GdkPixbuf *, n_images);

	for (i = 0; i < n_images; i++) {
		cell->images[i] = images[i];
		gdk_pixbuf_ref (cell->images[i]);

		if (gdk_pixbuf_get_height (cell->images[i]) > max_height)
			max_height = gdk_pixbuf_get_height (cell->images[i]);

	}

	cell->height = max_height;
	
	return (ECell *) cell;
}


