/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2001 CodeFactory AB
 * Copyright (C) 2001 Mikael Hallendal <micke@codefactory.se>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Mikael Hallendal <micke@codefactory.se>
 */

#ifndef __RESOURCE_MANAGER_H__
#define __RESOURCE_MANAGER_H__

#include <bonobo/bonobo-xobject.h>
#include "util/corba-utils.h"
#include "libmrproject/GNOME_MrProject.h"

#define TYPE_RESOURCE_MANAGER	          (resource_manager_get_type ())
#define RESOURCE_MANAGER(obj)		  (GTK_CHECK_CAST ((obj), TYPE_RESOURCE_MANAGER, ResourceManager))
#define RESOURCE_MANAGER_CLASS(klass)	  (GTK_CHECK_CLASS_CAST ((klass), TYPE_RESOURCE_MANAGER, ResourceManagerClass))
#define IS_RESOURCE_MANAGER(obj)	  (GTK_CHECK_TYPE ((obj), TYPE_RESOURCE_MANAGER))
#define IS_RESOURCE_MANAGER_CLASS(klass)  (GTK_CHECK_CLASS_TYPE ((obj), TYPE_RESOURCE_MANAGER))

typedef struct _ResourceManager      ResourceManager;
typedef struct _ResourceManagerClass ResourceManagerClass;
typedef struct _ResourceManagerPriv  ResourceManagerPriv;

typedef gboolean (*ResourceManagerForeachFunc) (ResourceManager  *manager,
						gpointer          res,
						gpointer          user_data);

struct _ResourceManager
{
	BonoboXObject            parent;
	ResourceManagerPriv     *priv;
};

struct _ResourceManagerClass
{
	BonoboXObjectClass                          parent_class;
	POA_GNOME_MrProject_ResourceManager__epv    epv;

	/*
	 * ResourceManagement functions
	 */
	
	/* CORBA Methods. */
	GM_Id              (*insert_resource) (ResourceManager   *rm,
					       const GM_Resource *res);
	GM_Resource *      (*get_resource)    (ResourceManager   *rm,
					       GM_Id              res_id);
	
	GSList *           (*get_all_resources) (ResourceManager *rm);
	gboolean           (*update_resource) (ResourceManager   *rm,
					       const GM_Resource *res);
	void               (*remove_resources) (ResourceManager   *rm,
						GSList            *res_ids);

	/* C Methods. */
	void               (*foreach_resource)(ResourceManager   *rm,
					       ResourceManagerForeachFunc func,
					       gpointer           user_data);

	/*
	 * GroupManagement functions
	 */
	
	/* CORBA Methods. */
	GM_Id              (*insert_group)    (ResourceManager   *rm,
					       const GM_ResourceGroup *g);
	GM_ResourceGroup * (*get_group)       (ResourceManager   *rm,
					       GM_Id              g_id);
	GSList *           (*get_all_groups)  (ResourceManager   *rm);
	gboolean           (*update_group)    (ResourceManager   *rm,
					       const GM_ResourceGroup *g);
	void               (*remove_group)    (ResourceManager   *rm,
					       GM_Id              id);

	GM_Id              (*get_default_group) (ResourceManager *rm);
	void               (*set_default_group) (ResourceManager *rm,
						 GM_Id            group_id);

	/* C Methods. */
	void               (*foreach_group)   (ResourceManager   *rm,
					       GHFunc             func,
					       gpointer           user_data);
};

GtkType    resource_manager_get_type    (void);
void       resource_manager_construct   (ResourceManager     *rm,
					 BonoboEventSource   *event_source);

void
resource_manager_foreach_resource     (ResourceManager              *manager,
				       ResourceManagerForeachFunc    func,
				       gpointer                      user_data);

void
resource_manager_foreach_group        (ResourceManager   *manager,
				       GHFunc             func,
				       gpointer           user_data);



#endif /* __RESOURCE_MANAGER_H__ */
