/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2001 CodeFactory AB
 * Copyright (C) 2001 Richard Hult <rhult@codefactory.se>
 * Copyright (C) 2001 Mikael Hallendal <micke@codefactory.se>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Richard Hult
 */

#ifndef __CORBA_UTIL_H__
#define __CORBA_UTIL_H__

#include "libmrproject/GNOME_MrProject.h"

/* Some defines to make life easier and the code more beautiful :) */

#define GM_Id			GNOME_MrProject_Id
#define GM_IdSeq		GNOME_MrProject_IdSeq
#define GM_Project              GNOME_MrProject_Project
#define GM_ProjectSeq           GNOME_MrProject_ProjectSeq
#define GM_ProjectState         GNOME_MrProject_ProjectState
#define GM_TaskManager		GNOME_MrProject_TaskManager		
#define GM_Task			GNOME_MrProject_Task		
#define GM_TaskSeq		GNOME_MrProject_TaskSeq
#define GM_Time                 GNOME_MrProject_Time
#define GM_Dependency		GNOME_MrProject_Dependency
#define GM_DependencySeq	GNOME_MrProject_DependencySeq
#define GM_DependencyType	GNOME_MrProject_DependencyType		
#define GM_TaskOrderType	GNOME_MrProject_TaskOrderType
#define GM_TaskType		GNOME_MrProject_TaskType
#define GM_TaskEdge		GNOME_MrProject_TaskEdge
#define GM_EventTaskInserted	GNOME_MrProject_EventTaskInserted

#define GM_ResourceManager	GNOME_MrProject_ResourceManager		
#define GM_Resource             GNOME_MrProject_Resource
#define GM_ResourceType         GNOME_MrProject_ResourceType
#define GM_ResourceSeq          GNOME_MrProject_ResourceSeq
#define GM_ResourceGroup        GNOME_MrProject_ResourceGroup
#define GM_ResourceGroupSeq     GNOME_MrProject_ResourceGroupSeq

#define GM_AllocationManager	GNOME_MrProject_AllocationManager	
#define GM_Allocation	        GNOME_MrProject_Allocation
#define GM_AllocationSeq        GNOME_MrProject_AllocationSeq

#define GM_Shell                GNOME_MrProject_Shell
#define GM_ShellView            GNOME_MrProject_ShellView
#define GM_ShellComponent       GNOME_MrProject_ShellComponent

#define GM_TaskDialog           GNOME_MrProject_TaskDialog
#define GM_TaskDialogPage       GNOME_MrProject_TaskDialogPage

#define GM_GeneralError         GNOME_MrProject_GeneralError  

#define GM_FileSummary          GNOME_MrProject_FileSummary

/* ... more ... */

typedef enum {
	TASK_CHANGE_NONE             = 0,
	TASK_CHANGE_PARENT           = 1 << 0,
	TASK_CHANGE_NAME             = 1 << 1,
	TASK_CHANGE_START            = 1 << 2,
	TASK_CHANGE_END              = 1 << 3,
	TASK_CHANGE_TYPE             = 1 << 4,
	TASK_CHANGE_PERCENT_COMPLETE = 1 << 5,
	TASK_CHANGE_ALL    = TASK_CHANGE_PARENT | TASK_CHANGE_NAME | TASK_CHANGE_START | TASK_CHANGE_END | TASK_CHANGE_TYPE | TASK_CHANGE_PERCENT_COMPLETE
} TaskChangeMask;

GM_Task          *corba_util_task_duplicate            (const GM_Task          *task);
void              corba_util_task_copy                 (GM_Task                *dst,
							const GM_Task          *src);
GM_Dependency    *corba_util_dependency_duplicate      (const GM_Dependency    *dependency);
void              corba_util_dependency_copy           (GM_Dependency          *dst,
							const GM_Dependency    *src);
TaskChangeMask    corba_util_task_update               (GM_Task                *dst,
							const GM_Task          *src,
							TaskChangeMask          mask);
GM_Resource      *corba_util_resource_duplicate        (const GM_Resource      *resource);
void              corba_util_resource_copy             (GM_Resource            *dst,
							const GM_Resource      *src);
gboolean          corba_util_resource_update           (GM_Resource            *dst,
							const GM_Resource      *src);
GM_ResourceGroup *corba_util_resource_group_duplicate  (const GM_ResourceGroup *group);

void              corba_util_resource_group_copy       (GM_ResourceGroup       *dst,
							const GM_ResourceGroup *src);

gboolean          corba_util_resource_group_update     (GM_ResourceGroup       *dst,
							const GM_ResourceGroup *src);

void              corba_util_allocation_copy           (GM_Allocation          *dst,
							const GM_Allocation    *src);

GM_Allocation    *corba_util_allocation_duplicate      (const GM_Allocation    *allocation);

GM_TaskSeq       *corba_util_task_seq_from_list        (GSList                 *list);

GM_ResourceSeq   *corba_util_resource_seq_from_list    (GSList                 *list);

GM_ResourceGroupSeq *corba_util_resource_group_seq_from_list  (GSList          *list);

GM_AllocationSeq *corba_util_allocation_seq_from_list  (GSList                 *list);

GM_IdSeq         *corba_util_id_seq_from_list          (GSList                 *list);

GSList           * corba_util_id_seq_to_list           (const GM_IdSeq         *id_seq);

GSList           *corba_util_id_string_to_list         (CORBA_char             *ids);
CORBA_char       *corba_util_id_string_from_list       (GSList                 *list);
GM_DependencySeq *corba_util_dependency_seq_from_list  (GSList                 *list);

GSList           *corba_util_task_seq_to_list          (GM_TaskSeq             *tasks);
GSList           *corba_util_resource_seq_to_list      (GM_ResourceSeq         *resources);
GSList           *corba_util_resource_group_seq_to_list(GM_ResourceGroupSeq    *groups);
GSList           *corba_util_dependency_seq_to_list    (GM_DependencySeq       *dependencys);
GSList           *corba_util_allocation_seq_to_list    (GM_AllocationSeq       *allocations);
void              g_slist_CORBA_free                   (GSList                 *list);
gboolean          corba_util_evolution_composer_exist  (void);
void              g_log_exception                      (CORBA_Environment      *ev,
							gchar                  *msg);

#define corba_util_set_exception(ev,ex_repoid,ex_type,ex_reason) G_STMT_START{	\
        ex_repoid *ex_data;						\
        ex_data = ex_repoid ## __alloc ();				\
	ex_data->msg.type = ex_type;					\
	ex_data->msg.reason = CORBA_string_dup (ex_reason);		\
									\
        CORBA_exception_set (ev, CORBA_USER_EXCEPTION,			\
			     ex_ ## ex_repoid, 				\
			     ex_data);}G_STMT_END


#endif /* __CORBA_UTIL_H__ */

