/*
 * $Id: IntegrationActionHandler.java 10489 2008-01-23 17:53:38Z dfeist $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSource, Inc.  All rights reserved.  http://www.mulesource.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.transport.bpm.jbpm.actions;

import org.mule.transport.bpm.ProcessConnector;

import org.jbpm.graph.exe.ExecutionContext;

public abstract class IntegrationActionHandler extends LoggingActionHandler
{

    private Object incoming;

    public void execute(ExecutionContext executionContext) throws Exception
    {
        super.execute(executionContext);
        incoming = executionContext.getVariable(ProcessConnector.PROCESS_VARIABLE_INCOMING);
    }

    protected Object getIncomingMessage()
    {
        return incoming;
    }

}
