//=========================================================
//  MusE
//  Linux Music Editor
//    $Id: tscale.cpp,v 1.1 2002/01/30 14:10:08 muse Exp $
//  (C) Copyright 1999 Werner Schweer (ws@seh.de)
//=========================================================

#include <stdio.h>
#include "tscale.h"

//---------------------------------------------------------
//   TScale
//---------------------------------------------------------

TScale::TScale(QWidget* parent, int ymag)
   : View(parent, 1, ymag)
      {
      setMouseTracking(true);
      setFixedWidth(18);
      }

//---------------------------------------------------------
//   draw
//---------------------------------------------------------

void TScale::pdraw(QPainter& p, const QRect& r)
      {
      int y = r.y();
      int h = r.height();
      QFont sfont("Helvetica", 8, QFont::Normal);
      p.setFont(sfont);
      QString s;
      for (int i = 30000; i <= 250000; i += 10000) {
            int yy =  mapy(280000 - i);
            if (yy < y)
                  break;
            if (yy-10 > y+h)
                  continue;
            p.drawLine(0, yy, 18, yy);
            s.setNum(i/1000);
            p.drawText(0, yy-1, s);
            }
      }

void TScale::viewMouseMoveEvent(QMouseEvent* event)
      {
      emit tempoChanged(280000 - event->y());
      }

void TScale::leaveEvent(QEvent*)
      {
      emit tempoChanged(-1);
      }

