//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: synthconfig.cpp,v 1.3 2002/02/08 09:56:29 muse Exp $
//
//  (C) Copyright 2001 Werner Schweer (ws@seh.de)
//=========================================================

#include <qlayout.h>
#include <qlistview.h>
#include <qpushbutton.h>
#include "synthconfig.h"
#include "app.h"
#include "synth.h"
#include "mess.h"
#include "driver/mididev.h"
#include "midiport.h"
#include "song.h"
#include "midithread.h"
#include "audiothread.h"

//---------------------------------------------------------
//   configSoftSynthesizer
//---------------------------------------------------------

void MusE::configSoftSynthesizer()
      {
      if (!softSynthesizerConfig)
            softSynthesizerConfig = new SynthesizerConfig();
      softSynthesizerConfig->show();
      }

//---------------------------------------------------------
//   SynthesizerConfig
//---------------------------------------------------------

SynthesizerConfig::SynthesizerConfig()
   : SynthConfigBase(0, "synthiTable")
      {
      songChanged(0);

      connect(song, SIGNAL(songChanged(int)), SLOT(songChanged(int)));
      connect(addInstance, SIGNAL(clicked()), SLOT(addInstanceClicked()));
      connect(removeInstance, SIGNAL(clicked()), SLOT(removeInstanceClicked()));
      }

//---------------------------------------------------------
//   songChanged
//---------------------------------------------------------

void SynthesizerConfig::songChanged(int)
      {
      synthList->clear();
      for (int i = 0; i < nsynthis; ++i) {
            if (synthis[i] == 0)    //DEBUG
                  continue;
            QString s = synthis[i]->baseName();
            QListViewItem* item = new QListViewItem(synthList);
            item->setText(0, s);
            s.setNum(synthis[i]->instances());
            item->setText(1, s);
            item->setText(2, synthis[i]->label());
            }
      instanceList->clear();
      for (iSynthI si = synthiInstances.begin(); si != synthiInstances.end(); ++si) {
            QListViewItem* iitem = new QListViewItem(instanceList);
            iitem->setText(0, (*si)->iname());
            QString port;
            port.sprintf("%d:%d",
               (*si)->mess()->alsaClient(),
               (*si)->mess()->alsaPort());
            iitem->setText(1, port);
            }
      }

//---------------------------------------------------------
//   addInstanceClicked
//---------------------------------------------------------

void SynthesizerConfig::addInstanceClicked()
      {
      QListViewItem* item = synthList->selectedItem();
      if (item == 0)
            return;
      SynthI* si = song->createSynthI(item->text(2));
      audioThread->msgAddSynthI(si);
      midiThread->msgAddSynthI(si);

      QString name(si->iname());
      QListViewItem* iitem = new QListViewItem(instanceList);
      iitem->setText(0, name);
      QString port;
      port.sprintf("%d:%d", si->mess()->alsaClient(), si->mess()->alsaPort());

      iitem->setText(1, port);

      song->updateAudioMixer();

      QString inst;
      inst.setNum(si->synth()->instances());
      item->setText(1, inst);
      }

//---------------------------------------------------------
//   removeInstanceClicked
//---------------------------------------------------------

void SynthesizerConfig::removeInstanceClicked()
      {
      QListViewItem* item = instanceList->selectedItem();
      if (item == 0)
            return;
      iSynthI ii;
      for (ii = synthiInstances.begin(); ii != synthiInstances.end(); ++ii) {
            if ((*ii)->iname() == item->text(0))
                  break;
            }
      if (ii == synthiInstances.end()) {
            printf("synthesizerConfig::removeInstanceClicked(): synthi not found\n");
            return;
            }
      int port;
      for (port = 0; port < MIDI_PORTS; ++port) {
            if (midiPorts[port].instrument() == *ii)
                  break;
            }
      if (port != MIDI_PORTS) {
            // synthi is attached
            midiThread->setMidiDevice(&midiPorts[port], 0);
            midiPorts[port].setInstrument(genericMidiInstrument);
#if 0
            for (iMidiDevice i = midiDevices.begin(); i != midiDevices.end(); ++i) {
                  MidiDevice* d = *i;
                  if (d->name() == (*ii)->iname()) {
                        printf("midi device %s found\n", d->name().latin1());
                        }
                  }
#endif
            }
      audioThread->msgRemoveSynthI(*ii);
      song->updateAudioMixer();
      song->update();
      }
