//=========================================================
//  MusE
//  Linux Music Editor
//    $Id: poslabel.h,v 1.1.1.1 2003/10/29 10:06:28 wschweer Exp $
//  (C) Copyright 2001 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __POSLABEL_H__
#define __POSLABEL_H__

#include <qlabel.h>

//---------------------------------------------------------
//   PosLabel
//---------------------------------------------------------

class PosLabel : public QLabel {
      bool _smpte;
      int _tickValue;
      int _sampleValue;
      Q_OBJECT

      void updateValue();

   protected:
      QSize sizeHint() const;

   public slots:
      void setTickValue(int);
      void setSampleValue(int);
      void setValue(int);

   public:
      PosLabel(QWidget* parent, const char* name = 0);
      int value()       const { return _smpte ? _sampleValue : _tickValue; }
      int tickValue()   const { return _tickValue; }
      int sampleValue() const { return _sampleValue; }
      void setSmpte(bool);
      bool smpte() const { return _smpte; }
      };


#endif


