/***************************************************************************
                          controller.h  -  description
                             -------------------
    begin                : Mon May 28 2001
    copyright            : (C) 2001 by 
    email                : maksik@gmx.co.uk
 ***************************************************************************/

#ifndef MCONTROLLER_H
#define MCONTROLLER_H

class MGnuPreferences;
class MGnuDirector;
struct SGnuUpload;
struct SGnuDownload;
struct SGnuNode;
struct SGnuSearch;
struct ResultGroup;
class MUI;
class MMutex;
class MControllerThread;
class MUIThread;
class MProperty;
class MPropertyContainer;

typedef void (*tEachSearch)(void* pData, SGnuSearch* pSearch);
typedef void (*tEachConnection)(void* pData, SGnuNode* pNode);
typedef void (*tEachUpload)(void* pData, SGnuUpload* pUpload);
typedef void (*tEachDownload)(void* pData, SGnuDownload* pDownload);

//typedef void (tEachGroup)(void* pData, ResultGroup* pResGrp);
//typedef void (tEachResult)(void* pData, Result* pResult);

class MController {
friend class MControllerThread;
friend class MUIThread;
public: 
	MController();
	~MController();
	
	bool Init();
	void Do();
	void LoadPartials(const CString& partDir);
	void LoadSearches();
	void SaveSearches();
	MProperty* GetProperty(LPCSTR szName);
	MPropertyContainer* GetPropertyContainer(){return m_pPropCont;}
	// AddProperty methods
	
	// methods
	MGnuPreferences* GetPrefs();
	void Attach(MGnuDirector*);
	void Detach(MGnuDirector*);
	MGnuDirector* GetDirector();
	//
	bool AddSearchUsr(const CString& search, int size, int sizeMode);
	void ForEachSearch(void* pData, tEachSearch callback);
	bool GetSearchByID(DWORD dwID, SGnuSearch& gs, std::vector<Result>& rv, std::vector<ResultGroup>& gv);
	bool GetResultsByID(DWORD dwID, std::vector<Result>& rv);
	bool RemoveSearchByID(DWORD dwID);
	bool ClearSearchByID(DWORD dwID);
	bool GroupResults();
	//
	void ForEachConnection(void* pData, tEachConnection callback);
	bool CloseConnectionByID(DWORD dwID);
	void OpenConnection(const char* host, int port);
	DWORD GetConnRateRecv();
	DWORD GetConnRateSend();
	//
	void ForEachUpload(void* pData, tEachUpload callback);
	void ForEachDownload(void* pData, tEachDownload callback);
	bool RemoveTransferByID(DWORD dwID, bool bDelPart);
	void AddDownload(Result& result);
	void AddDownload(const ResultVec& results);
	//
	void Rescan();
	void GetSharedFiles(std::vector<SharedFile>&);
	//
	void UpdateHits();
	// statistics
	void GetNetStats(int& nHosts, int& nSharingHosts, int& nFiles, int& nSize);
	void GetConnStats(int& nConn, int& nUpl, int& nDownl);
	void GetBandwidthStats(int& nConn, int& nUpl, int& nDownl);
    //
    void GetNodeCache(std::list<Node>& list);
protected:
	MGnuDirector * m_pDirector;
	MGnuPreferences * m_pPrefs;
	MUI* m_pUI;
	MMutex* m_pUIMutex;
	MControllerThread* m_pNetworkThread;
	MUIThread* m_pUIThread;
	MPropertyContainer* m_pPropCont;
	//
	bool AddSearch(const CString& sSearch, const CString& sOptions);
};

#endif
