/***************************************************************************
                          gnuwebcache.h  -  description
                             -------------------
    begin                : Fri Sep 27 2002
    copyright            : (C) 2002 by Max Zaitsev
    email                : maksik@gmx.co.uk
 ***************************************************************************/

#ifndef GNUWEBCACHE_H
#define GNUWEBCACHE_H

/**
***@author Max Zaitsev
***/

class MGnuWebCache : public MAsyncSocket  {
public: 
	MGnuWebCache(MGnuDirector* pDirector);
	~MGnuWebCache();
	
	enum RequestType{
		Invalid      = 0x0000,
		HostFile     = 0x0001,
		UrlFile      = 0x0002,
		Update       = 0x0003,
		Ping         = 0x0004,
		Redirect     = 0x1000,
		HostRedirect = Redirect | HostFile,
		UrlRedirect  = Redirect | UrlFile
	};
	
	bool Connect(const CString& sURL, RequestType request);
	//
	virtual void OnReceive(int nErrorCode);
	virtual void OnSend(int nErrorCode);
	virtual void OnConnect(int nErrorCode);
	virtual void OnClose(int nErrorCode);
	//
	void OnTimer(int nTimeStamp);
	//
	bool IsValid(){ return m_bValid; }
protected:
	// members
	MGnuDirector* m_pDirector;
	//
	int m_nLastActive;
	bool m_bValid;
	RequestType m_request;
	CString m_sURL;
	CString m_sHost;
	CString m_sPath;
	//
	int   m_nBytesReceived;
	char* m_pBuffer;
private:
	MGnuWebCache(); // no implementation
};

#endif
