<?php
//    MyDMS. Document Management System
//    Copyright (C) 2002-2005  Markus Westphal
//    Copyright (C) 2006 Malcolm Cowe
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

include("../inc/inc.Settings.php");
include("../inc/inc.AccessUtils.php");
include("../inc/inc.ClassAccess.php");
include("../inc/inc.ClassDocument.php");
include("../inc/inc.ClassFolder.php");
include("../inc/inc.ClassGroup.php");
include("../inc/inc.ClassUser.php");
include("../inc/inc.DBAccess.php");
include("../inc/inc.FileUtils.php");
include("../inc/inc.Language.php");
include("../inc/inc.ClassUI.php");
include("../inc/inc.Authentication.php");

UI::htmlStartPage(getMLText("admin_tools"));
UI::globalNavigation();

if (!$user->isAdmin()) {
	UI::pageNavigation(getMLText("access_denied"));
	UI::htmlEndPage();
	exit;
}
UI::pageNavigation(getMLText("admin_tools"), "admin_tools");

$action = $_GET["action"];
//Neue Gruppe anlegen -----------------------------------------------------------------------------
if ($action == "addgroup") {
	UI::contentHeading(getMLText("add_group"));
	UI::contentContainerStart();
	printMLText("adding_group");

	$name = sanitizeString($_GET["name"]);
	$comment = sanitizeString($_GET["comment"]);

	if (is_object(getGroupByName($name))) {
		print "<p>".getMLText("group_exists")."</p>";
		UI::contentContainerEnd();
		UI::htmlEndPage();
		exit;
	}

	$newGroup = addGroup($name, $comment);
	if ($newGroup) {
		printMLText("op_finished");
	}
	else {
		printMLText("error_occured");
	}
}

//Gruppe lschen ----------------------------------------------------------------------------------
else if ($action == "removegroup") {
	UI::contentHeading(getMLText("rm_group"));
	UI::contentContainerStart();
	printMLText("removing_group");
	
	if (!isset($_GET["groupid"]) || !is_numeric($_GET["groupid"]) || intval($_GET["groupid"])<1) {
		print "<p>".getMLText("invalid_group_id")."</p>";
		UI::contentContainerEnd();
		UI::htmlEndPage();
		exit;
	}
	$group = getGroup($_GET["groupid"]);
	if (!is_object($group)) {
		print "<p>".getMLText("invalid_group_id")."</p>";
		UI::contentContainerEnd();
		UI::htmlEndPage();
		exit;
	}

	if ($group->remove()) {
		printMLText("op_finished");
	}
	else {
		printMLText("error_occured");
	}
}

//Gruppe bearbeiten -------------------------------------------------------------------------------
else if ($action == "editgroup") {
	UI::contentHeading(getMLText("edit_group"));
	UI::contentContainerStart();
	printMLText("editing_group");

	if (!isset($_GET["groupid"]) || !is_numeric($_GET["groupid"]) || intval($_GET["groupid"])<1) {
		print "<p>".getMLText("invalid_group_id")."</p>";
		UI::contentContainerEnd();
		UI::htmlEndPage();
		exit;
	}
	$group = getGroup($_GET["groupid"]);
	if (!is_object($group)) {
		print "<p>".getMLText("invalid_group_id")."</p>";
		UI::contentContainerEnd();
		UI::htmlEndPage();
		exit;
	}
	
	$name = sanitizeString($_GET["name"]);
	$comment = sanitizeString($_GET["comment"]);

	if ($group->getName() != $name)
		$group->setName($name);
	if ($group->getComment() != $comment)
		$group->setComment($comment);

	printMLText("op_finished");
}

//Benutzer zu Gruppe hinzufgen -------------------------------------------------------------------
else if ($action == "addmember") {
	UI::contentHeading(getMLText("add_member"));
	UI::contentContainerStart();
	printMLText("adding_member");

	if (!isset($_GET["groupid"]) || !is_numeric($_GET["groupid"]) || intval($_GET["groupid"])<1) {
		print "<p>".getMLText("invalid_group_id")."</p>";
		UI::contentContainerEnd();
		UI::htmlEndPage();
		exit;
	}
	$group = getGroup($_GET["groupid"]);
	if (!is_object($group)) {
		print "<p>".getMLText("invalid_group_id")."</p>";
		UI::contentContainerEnd();
		UI::htmlEndPage();
		exit;
	}

	if (!isset($_GET["userid"]) || !is_numeric($_GET["userid"]) || intval($_GET["userid"])<1) {
		print "<p>".getMLText("invalid_user_id")."</p>";
		UI::contentContainerEnd();
		UI::htmlEndPage();
		exit;
	}
	$newMember = getUser($_GET["userid"]);
	if (!is_object($newMember)) {
		print "<p>".getMLText("invalid_user_id")."</p>";
		UI::contentContainerEnd();
		UI::htmlEndPage();
		exit;
	}

	$group->addUser($newMember);
	printMLText("op_finished");
}

//Benutzer aus Gruppe entfernen -------------------------------------------------------------------
else if ($action == "rmmember") {
	UI::contentHeading(getMLText("remove_member"));
	UI::contentContainerStart();
	printMLText("removing_member");

	if (!isset($_GET["groupid"]) || !is_numeric($_GET["groupid"]) || intval($_GET["groupid"])<1) {
		print "<p>".getMLText("invalid_group_id")."</p>";
		UI::contentContainerEnd();
		UI::htmlEndPage();
		exit;
	}
	$group = getGroup($_GET["groupid"]);
	if (!is_object($group)) {
		print "<p>".getMLText("invalid_group_id")."</p>";
		UI::contentContainerEnd();
		UI::htmlEndPage();
		exit;
	}

	if (!isset($_GET["userid"]) || !is_numeric($_GET["userid"]) || intval($_GET["userid"])<1) {
		print "<p>".getMLText("invalid_user_id")."</p>";
		UI::contentContainerEnd();
		UI::htmlEndPage();
		exit;
	}
	$oldMember = getUser($_GET["userid"]);
	if (!is_object($oldMember)) {
		print "<p>".getMLText("invalid_user_id")."</p>";
		UI::contentContainerEnd();
		UI::htmlEndPage();
		exit;
	}

	$group->removeUser($oldMember);
	printMLText("op_finished");
}

UI::contentContainerEnd();
UI::htmlEndPage();
?>
