<?php
//    MyDMS. Document Management System
//    Copyright (C) 2002-2005  Markus Westphal
//    Copyright (C) 2006 Malcolm Cowe
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

include("../inc/inc.Settings.php");
include("../inc/inc.AccessUtils.php");
include("../inc/inc.ClassAccess.php");
include("../inc/inc.ClassDocument.php");
include("../inc/inc.ClassFolder.php");
include("../inc/inc.ClassGroup.php");
include("../inc/inc.ClassUser.php");
include("../inc/inc.ClassEmail.php");
include("../inc/inc.DBAccess.php");
include("../inc/inc.FileUtils.php");
include("../inc/inc.Language.php");
include("../inc/inc.ClassUI.php");
include("../inc/inc.Authentication.php");

if (!isset($_POST["documentid"]) || !is_numeric($_POST["documentid"]) || intval($_POST["documentid"])<1) {
	UI::htmlStartPage(getMLText("document_title", array("documentname" => getMLText("invalid_doc_id"))));
	UI::globalNavigation();
	UI::pageNavigation(getMLText("invalid_doc_id"));
	UI::htmlEndPage();
	exit;
}

$documentid = $_POST["documentid"];
$document = getDocument($documentid);
if (!is_object($document)) {
	UI::htmlStartPage(getMLText("document_title", array("documentname" => getMLText("invalid_doc_id"))));
	UI::globalNavigation();
	UI::pageNavigation(getMLText("invalid_doc_id"));
	UI::htmlEndPage();
	exit;
}

$folder = $document->getFolder();
$docPathHTML = getFolderPathHTML($folder, true). " / <a href=\"../out/out.ViewDocument.php?documentid=".$documentid."\">".$document->getName()."</a>";

UI::htmlStartPage(getMLText("document_title", array("documentname" => $document->getName())));
UI::globalNavigation($folder);
UI::pageNavigation($docPathHTML, "view_document");

UI::contentHeading(getMLText("update_document") . ": " . $document->getName());

if ($document->getAccessMode($user) < M_READWRITE) {
	UI::contentContainer(getMLText("operation_not_allowed"));
	UI::htmlEndPage();
	exit;
}

UI::contentContainerStart();

if ($document->isLocked()) {
	$lockingUser = $document->getLockingUser();
		
	if (($lockingUser->getID() != $user->getID()) && ($document->getAccessMode($user) != M_ALL)) {
		printMLText("update_locked_msg", array("username" => $lockingUser->getFullName(), "email" => $lockingUser->getEmail()));
		printMLText("no_update_cause_locked");

		UI::contentContainerEnd();
		UI::htmlEndPage();
		exit;
	}
	else
		$document->setLocked(false);
}


if (is_uploaded_file($_FILES["userfile"]["tmp_name"]) && $_FILES["userfile"]["size"] > 0 && $_FILES['userfile']['error']==0) {
	printMLText("updating_document");
		
	$comment  = sanitizeString($_POST["comment"]);
	$userfiletmp = $_FILES["userfile"]["tmp_name"];
	$userfiletype = sanitizeString($_FILES["userfile"]["type"]);
	$userfilename = sanitizeString($_FILES["userfile"]["name"]);
		
	$lastDotIndex = strrpos(basename($userfilename), ".");
	if (is_bool($lastDotIndex) && !$lastDotIndex)
		$fileType = ".";
	else
		$fileType = substr($userfilename, $lastDotIndex);

	// Get the list of reviewers and approvers for this document.
	$reviewers = array();
	$approvers = array();
	if (isset($_POST["assignDocReviewers"])) {
		// Retrieve the list of individual reviewers from the form.
		$reviewers["i"] = array();
		if (isset($_POST["indReviewers"])) {
			foreach ($_POST["indReviewers"] as $ind) {
				$reviewers["i"][] = $ind;
			}
		}
		// Retrieve the list of reviewer groups from the form.
		$reviewers["g"] = array();
		if (isset($_POST["grpReviewers"])) {
			foreach ($_POST["grpReviewers"] as $grp) {
				$reviewers["g"][] = $grp;
			}
		}
	}
	if (isset($_POST["assignDocApprovers"])) {
		// Retrieve the list of individual approvers from the form.
		$approvers["i"] = array();
		if (isset($_POST["indApprovers"])) {
			foreach ($_POST["indApprovers"] as $ind) {
				$approvers["i"][] = $ind;
			}
		}
		// Retrieve the list of approver groups from the form.
		$approvers["g"] = array();
		if (isset($_POST["grpApprovers"])) {
			foreach ($_POST["grpApprovers"] as $grp) {
				$approvers["g"][] = $grp;
			}
		}
	}

	$contentResult=$document->addContent($comment, $user, $userfiletmp, basename($userfilename), $fileType, $userfiletype, $reviewers, $approvers);
	if (is_bool($contentResult) && !$contentResult) {
		printMLText("error_occured");
	}
	else {
		$expires = ($_POST["expires"] == "true") ? mktime(0,0,0, $_POST["expmonth"], $_POST["expday"], $_POST["expyear"]) : false;
			
		if (!$document->setExpires($expires)) {
			printMLText("error_occured");
		}
		else {
			printMLText("op_finished");

			$status = $contentResult->getStatus();
			// Display review request summary.
			// Individuals:
			$indReviewers = $contentResult->getReviewers("i");
			if (count($indReviewers)) {
				UI::contentSubHeading(getMLText("individual_reviewers"));
				print "<ul class=\"reviewer\">";
				if (count($indReviewers[0])) {
					foreach ($indReviewers[0] as $reviewer) {
						print "<li>".$reviewer->getFullName()." &lt;".$reviewer->getEmail()."> ".getMLText("reviewer_added").". ";
						if ($status == 0) {
							print getMLText("email_sent").".";
						}
					}
				}
				if (count($indReviewers[-4])) {
					foreach ($indReviewers[-4] as $reviewer) {
						print "<li>".$reviewer->getFullName()." &lt;".$reviewer->getEmail()."> ".getMLText("reviewer_added").". ";
						printMLText("email_err_user");
					}
				}
				if (count($indReviewers[-3])) {
					foreach ($indReviewers[-3] as $reviewer) {
						print "<li>".$reviewer->getFullName()." &lt;".$reviewer->getEmail()."> ".getMLText("reviewer_already_assigned").".";
					}
				}
				if (count($indReviewers[-2])) {
					foreach ($indReviewers[-2] as $reviewer) {
						print "<li>".$reviewer->getFullName()." &lt;".$reviewer->getEmail()."> ".getMLText("reviewer_no_privilege").".";
					}
				}
				if (count($indReviewers[-1])) {
					foreach ($indReviewers[-1] as $reviewer) {
						print "<li>".getMLText("unable_to_add")." ".$reviewer->getFullName()." &lt;".$reviewer->getEmail()."> ".getMLText("as_reviewer").". ".getMLText("internal_error").".";
					}
				}
				print "</ul>";
			}
			// Groups:
			$grpReviewers = $contentResult->getReviewers("g");
			if (count($grpReviewers)) {
				UI::contentSubHeading(getMLText("individual_reviewers"));
				print "<ul class=\"reviewers\">";
				if (count($grpReviewers[0])) {
					foreach ($grpReviewers[0] as $reviewer) {
						print "<li>".getMLText("group")." '".$reviewer->getName()."' ".getMLText("reviewer_added").". ";
						if ($status == 0) {
							print getMLText("group_email_sent").".";
						}
					}
				}
				if (count($grpReviewers[-4])) {
					foreach ($grpReviewers[-4] as $reviewer) {
						print "<li>".getMLText("group")." '".$reviewer->getName()."' ".getMLText("reviewer_added").". ";
						printMLText("email_err_group");
					}
				}
				if (count($grpReviewers[-3])) {
					foreach ($grpReviewers[-3] as $reviewer) {
						print "<li>".getMLText("group")." '".$reviewer->getName()."' ".getMLText("reviewer_already_assigned").".";
					}
				}
				if (count($grpReviewers[-2])) {
					foreach ($grpReviewers[-2] as $reviewer) {
						print "<li>".getMLText("group")." '".$reviewer->getName()."' ".getMLText("reviewer_no_privilege").".";
					}
				}
				if (count($grpReviewers[-1])) {
					foreach ($grpReviewers[-1] as $reviewer) {
						print "<li>".getMLText("group_unable_to_add")." '".$reviewer->getName()."' ".getMLText("as_reviewer").". ".getMLText("internal_error").".";
					}
				}
				print "</ul>";
			}
			
			// Display approve request summary.
			// Individuals:
			$indApprovers = $contentResult->getApprovers("i");
			if (count($indApprovers)) {
				UI::contentSubHeading(getMLText("individual_approvers"));
				print "<ul>";
				if (count($indApprovers[0])) {
					foreach ($indApprovers[0] as $approver) {
						print "<li>".$approver->getFullName()." &lt;".$approver->getEmail()."> ".getMLText("approver_added").". ";
						if ($status == 1) {
							print getMLText("email_sent").".";
						}
					}
				}
				if (count($indApprovers[-4])) {
					foreach ($indApprovers[-4] as $approver) {
						print "<li>".$approver->getFullName()." &lt;".$approver->getEmail()."> ".getMLText("approver_added").". ";
						printMLText("email_err_user");
					}
				}
				if (count($indApprovers[-3])) {
					foreach ($indApprovers[-3] as $approver) {
						print "<li>".$approver->getFullName()." &lt;".$approver->getEmail()."> ".getMLText("approver_already_assigned").".";
					}
				}
				if (count($indApprovers[-2])) {
					foreach ($indApprovers[-2] as $approver) {
						print "<li>".$approver->getFullName()." &lt;".$approver->getEmail()."> ".getMLText("approver_no_privilege").".";
					}
				}
				if (count($indApprovers[-1])) {
					foreach ($indApprovers[-1] as $approver) {
						print "<li>".getMLText("unable_to_add")." ".$approver->getFullName()." &lt;".$approver->getEmail()."> ".getMLText("as_approver").". ".getMLText("internal_error").".";
					}
				}
				print "</ul>";
			}
			// Groups:
			$grpApprovers = $contentResult->getApprovers("g");
			if (count($grpApprovers)) {
				UI::contentSubHeading(getMLText("group_approvers"));
				print "<ul>";
				if (count($grpApprovers[0])) {
					foreach ($grpApprovers[0] as $approver) {
						print "<li>".getMLText("group")." '".$approver->getName()."' ".getMLText("approver_added").". ";
						if ($status == 1) {
							print getMLText("group_email_sent").".";
						}
					}
				}
				if (count($grpApprovers[-4])) {
					foreach ($grpApprovers[-4] as $approver) {
						print "<li>".getMLText("group")." '".$approver->getName()."' ".getMLText("approver_added").". ";
						printMLText("email_err_group");
					}
				}
				if (count($grpApprovers[-3])) {
					foreach ($grpApprovers[-3] as $approver) {
						print "<li>".getMLText("group")." '".$approver->getName()."' ".getMLText("approver_already_assigned").".";
					}
				}
				if (count($grpApprovers[-2])) {
					foreach ($grpApprovers[-2] as $approver) {
						print "<li>".getMLText("group")." '".$approver->getName()."' ".getMLText("approver_no_privilege").".";
					}
				}
				if (count($grpApprovers[-1])) {
					foreach ($grpApprovers[-1] as $approver) {
						print "<li>".getMLText("group_unable_to_add")." '".$approver->getName()."' ".getMLText("as_approver").". ".getMLText("internal_error").".";
					}
				}
				print "</ul>";
			}

			// Display status summary.
			UI::contentSubHeading(getMLText("document_status"));
			printOverallStatusText($status);
		}
	}
}
else {
	printMLText("uploading_failed");
}

UI::contentContainerEnd();
UI::htmlEndPage();
?>
