#!/bin/sh

#
# MyODBC 3.51 RPM spec 
#

%define myodbc_version @VERSION@
%define release 1

Name:		MyODBC
Summary:	An ODBC 3.51 driver for MySQL
Group:		Applications/Databases
Version:	%{myodbc_version}
Release:	1
Copyright:	Public Domain, GPL
Source0:	%{name}-%{version}.tar.gz
URL:		http://www.mysql.com/
Vendor:		MySQL AB
Packager:	Peter Harvey<peterh@mysql.com>

%define prefix /usr/local

# Think about what you use here since the first step is to
# run a rm -rf
BuildRoot:	%{_tmppath}/%{name}-%{version}-build

# From the manual
%description
MyODBC is a 32-bit ODBC (3.50) level 0 (with level 1 and level 2 features)
driver for connecting an ODBC-aware application to MySQL. MyODBC works on
Windows 9x/Me/NT/2000/XP, and most Unix platforms (incl. OSX and Linux).

MyODBC 3.51 is an enhanced version of MyODBC 2.50 to meet ODBC 3.5 
specification. The driver is commonly referred to as 'MySQL ODBC 3.51 Driver'.

%prep
%setup -n %{name}-%{version}

%define ODBC_DM_PATH @ODBC_DM_PATH@
%define MYSQL_LIBS  @MYSQL_USED_LIB_PATH@
%define MYSQL_INCLUDES @MYSQL_USED_INCLUDE_PATH@

%build
./configure \
	--prefix=${RPM_BUILD_ROOT}%{prefix} \
  --with-mysql-libs=%{MYSQL_LIBS} \
  --with-mysql-includes=%{MYSQL_INCLUDES} \
  %{ODBC_DM_PATH} \
  --enable-thread-safe \
  --enable-shared=yes \
  --enable-static=yes \
  --without-debug \
  --without-docs
make

%clean 
rm -rf $RPM_BUILD_ROOT

%install
make PREFIX=$RPM_BUILD_ROOT install

find ${RPM_BUILD_ROOT}%{prefix} -type f -print | sed "s@^${RPM_BUILD_ROOT}@@g" > myodbc-filelist
find ${RPM_BUILD_ROOT}%{prefix} -type l -print | sed "s@^${RPM_BUILD_ROOT}@@g" >> myodbc-filelist

%files -f myodbc-filelist
%defattr(-,root,root)

%doc INSTALL-BINARY
%doc ChangeLog
%doc odbc.ini
%doc README
%doc RELEASE-NOTES
