// test_xml.cpp : Defines the entry point for the console application.
//

#include "stdio.h"
#include "stdlib.h"
#include "myx_public_interface.h"

char * filename_in= "in.xml";
char * filename_out= "out.xml";

void print_usage()
{
  printf("usage : test_xml.exe [charsets|datatypes|options|connections]\n");
}

MYX_PASSWORD_STORAGE_TYPE get_storage_type()
{
  char * var= getenv("MYX_PASSWORD_STORAGE_TYPE");
  if (!var)
  {
    return MYX_PASSWORD_NOT_STORED;
  }
  else
  {
    int res= MYX_PASSWORD_NOT_STORED;
    sscanf(var,"%d",&res);
    return (MYX_PASSWORD_STORAGE_TYPE)res;
  }
}

int main(int argc, char *argv[])
{
  MYX_LIB_ERROR err;

  if (argc<2)
  {
    print_usage();
  }
  else if (!strcmp(argv[1],"charsets"))
  {
    MYX_DBM_CHARSETS * charsets= myx_charsets_load(filename_in,&err);
    myx_charsets_store(filename_out,charsets);
    myx_free_charsets(charsets);
  }
  else if (!strcmp(argv[1],"datatypes"))
  {
    MYX_DBM_DATATYPES * datatypes= myx_datatype_load(filename_in,&err);
    myx_datatype_store(filename_out,datatypes);
    myx_free_datatype(datatypes);
  }
  else if (!strcmp(argv[1],"options"))
  {
    MYX_APPLICATION_OPTIONS * options=
                                 myx_get_application_options(filename_in,&err);
    myx_store_application_options(options,filename_out);
    myx_free_application_options(options);
  }
  else if (!strcmp(argv[1],"connections"))
  {
    MYX_USER_CONNECTIONS * connections= 
                                   myx_load_user_connections(filename_in,&err);
    myx_store_user_connections(connections,get_storage_type(),filename_out);
    myx_free_user_connections(connections);
  }
  else
  {
    print_usage();
  }

  return 0;
}

