//
//  MWLayerTree.h
//  MySQL Workbench
//
//  Created by Alfredo Kojima on 05/8/3.
//  Copyright 2005 MySQL AB. All rights reserved.
//

#import <Cocoa/Cocoa.h>

#include <MySQLGRT/myx_grt_public_interface.h>
#include <glib.h>

@interface MWElementTreeNode : NSObject
{
  NSString *_description;
  MYX_GRT_VALUE *_element;
  MYX_GRT_VALUE *_object;
}

- (id)initWithGRT:(MYX_GRT*)grt
          element:(MYX_GRT_VALUE*)element;

- (MYX_GRT_VALUE*)value;
- (NSString*)description;
@end


@interface MWLayerTreeNode : NSObject 
{
  NSString *_description;
  NSMutableArray *_children;
  NSMutableArray *_elements;
  
  MYX_GRT *_grt;
  MYX_GRT_VALUE *_layer;
}

- (id)initWithGRT:(MYX_GRT*)grt
            layer:(MYX_GRT_VALUE*)value;
- (NSString*)description;
- (NSMutableArray*)children;
- (NSArray*)elements;
- (void)update;
- (void)scanSublayers;
- (void)scanElements;
- (MYX_GRT_VALUE*)value;
@end



@interface MWLayerDataSource : NSObject 
{
  MYX_GRT *_grt;
  MWLayerTreeNode *_rootLayer;
  GHashTable *_layerTable;
  NSString *_path;
}

- (id)initWithGRT:(MYX_GRT*)grt;

- (void)setRootLayerPath:(NSString*)path;

- (void)handleElementAdd:(MYX_GRT_VALUE*)value;
- (void)handleElementChange:(MYX_GRT_VALUE*)value;
- (void)handleElementDelete:(MYX_GRT_VALUE*)value;

- (MWLayerTreeNode*)handleLayerAdd:(MYX_GRT_VALUE*)value;
- (void)handleLayerDelete:(MYX_GRT_VALUE*)value;
- (void)handleLayerChange:(MYX_GRT_VALUE*)value;
- (void)handleLayerMove:(MYX_GRT_VALUE*)value;

@end
