/* Copyright (C) 2004 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

/**
 * @file myx_gc_utilities.h 
 * @brief Some common utility functions.
 * 
 */

#ifndef __GC_GL_UTILITIES_H__
#define __GC_GL_UTILITIES_H__

#include "myx_gc_datatypes.h"

#include "glib.h"
#include "png.h"

//----------------------------------------------------------------------------------------------------------------------

typedef enum tagColorType
{
  COLOR_TYPE_PALETTE =     PNG_COLOR_TYPE_PALETTE,
  COLOR_TYPE_GRAY =        PNG_COLOR_TYPE_GRAY,
  COLOR_TYPE_GRAY_ALPHA =  PNG_COLOR_TYPE_GRAY_ALPHA,
  COLOR_TYPE_RGB =         PNG_COLOR_TYPE_RGB,
  COLOR_TYPE_RGB_ALPHA =   PNG_COLOR_TYPE_RGB_ALPHA
} TColorType;

typedef struct tagTImage
{
  unsigned int Width;     // The width of the image in pixels.
  unsigned int Height;    // The height of the image in pixels.
  unsigned char* Data;    // The image data.
  TColorType ColorType;    // The color format of the image (RGB, gray, palette etc.)
                           // Note: Palette images are not supported.
  unsigned int Channels;  // Bytes per pixel.
} TImage;

//----------------------------------------------------------------------------------------------------------------------

// Converts the given string, which is supposed to be an UTF-8 encoded text into an UTF-16 string.
wstring Utf8ToUtf16(const string& Source);

// Converts the given string into an ANSI string using the current system locale.
wstring Utf16ToANSI(const string& Source);

// Converts the given string, which is supposed to be an UTF-8 encoded text into an ANSI string using the current system locale.
string Utf8ToANSI(const string& Source);

// Loads the given PNG image from disk.
TImage* LoadPNG(const string& Filename);

// Releases the given image.
void FreeImage(TImage* Image);

// Returns the current working folder.
string GetCurrentDir(void);

// Sets the current working folder.
void SetCurrentDir(const string& Folder);

// Extracts the drive and path from the given file name.
string ExtractFilePath(const string& Filename);

// Platform neutral file open function.
FILE* OpenFile(string Filename, const char* OpenMode);

//----------------------------------------------------------------------------------------------------------------------

#endif // __GC_GL_UTILITIES_H__