!	This generates an ncview overlay file from a netCDF topography
!	file.  The topog file I developed this for is:
!	/data/obs/topo/etopo_5/etopo5.nc
!	and is a world bathymetry at about 0.08 deg
!	resolution.
!
!	Useage:
!		genoverlay topog_file_name.nc > overlay_file
!
!	David W Pierce
!	Scripps Institition of Oceanography 
!	Climate Research Division
!	4/18/97

program genoverlay

	implicit none

	include 'crdnetcdf.inc'

	integer			:: iargc, ncid, varid, ndims, nts, nx, ny, me, &
				   n, s, e, w, i, j
	integer, allocatable	:: dimsizes(:), mask(:,:), edge(:,:)
	character*100		:: fname, title
	external	   	   iargc
	real, allocatable	:: data(:,:), lat(:), lon(:)
	real			:: isobath_value

	isobath_value = 0.0	! What contour to return the overlay of [meters]

	if( iargc() /= 1 ) then
		write(0,*) 'Error: takes one argument, name of netCDF format topog file'
		stop 
	endif

	call getarg( 1, fname )
	ncid = iopenfile( fname, title )
	write(0,*) 'Reading from ', trim(title)

	varid = ivarinfo( ncid, 'bath', ndims, nts )
	allocate( dimsizes(ndims) )

	call ivardimsizes( ncid, varid, dimsizes )
	nx = dimsizes(1)
	ny = dimsizes(2)
	allocate( data(nx,ny) )
	allocate( mask(nx,ny) )
	allocate( edge(nx,ny) )
	allocate( lon(nx) )
	allocate( lat(ny) )

	call ncvgtdata( ncid, varid, data )

	varid = ivarinfo( ncid, 'X', ndims, nts )
	call ncvgtdata( ncid, varid, lon )

	varid = ivarinfo( ncid, 'Y', ndims, nts )
	call ncvgtdata( ncid, varid, lat )

	where( data < isobath_value )
		mask = 0
	elsewhere
		mask = 1
	endwhere

	do j=1, ny
	do i=1, nx
		me = mask(i,j)
		if( me == 1 ) then
			if( j == ny ) then
				n = me
			else
				n = mask(i,j+1)
			endif
			if( j == 1 ) then
				s = me
			else
				s = mask(i,j-1)
			endif
			if( i == nx ) then
				e = mask(1,j)
			else
				e = mask(i+1,j)
			endif
			if( i == 1 ) then
				w = mask(nx,j)
			else
				w = mask(i-1,j)
			endif
			if( (me /= n) .or.	&
			    (me /= s) .or.	&
			    (me /= e) .or.	&
			    (me /= w)) then
				edge(i,j) = 1
			else
				edge(i,j) = 0
			endif
		else
			edge(i,j) = 0
		endif
	enddo
	enddo

	do j=1, ny
	do i=1, nx
		if( edge(i,j) == 1 ) then
			write(6,100) lon(i), lat(j)
			if( lon(i) > 180.0 ) then
				write(6,100) lon(i)-360.0, lat(j)
			endif
100			format( 2f8.3 )
		endif
	enddo
	enddo

end program genoverlay
