#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10729);
 script_cve_id("CAN-2001-0653");
 script_bugtraq_id(3163);
 
 name["english"] = "Sendmail 8.11 local overflow";
 name["francais"] = "Dpassement de buffer local dans sendmail 8.11";
 script_name(english:name["english"],
 	     francais:name["francais"]);
 
 desc["english"] = "
The remote sendmail server, according to its version number,
may be vulnerable to a local buffer overflow allowing local
users to gain root privileges.

Solution : Upgrade to Sendmail 8.12beta19 or 8.11.6
Risk factor : High (Local) / None (remote with no account)"; 
	
 script_description(english:desc["english"],
 	 	    francais:desc["francais"]);
		    
 
 summary["english"] = "Checks the version number"; 
 summary["francais"] = "Vrification du numro de srie de sendmail";
 script_summary(english:summary["english"],
 		 francais:summary["francais"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2001 Renaud Deraison",
 		  francais:"Ce script est Copyright (C) 2001 Renaud Deraison");
 
 family["english"] = "SMTP problems";
 family["francais"] = "Problmes SMTP";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes", "smtpserver_detect.nasl");
 script_require_ports("Services/smtp", 25);
 exit(0);
}

#
# The script code starts here
#

port = get_kb_item("Services/smtp");
if(!port) port = 25;

banner = get_kb_item(string("smtp/banner/", port));
if(!banner)
{
 if(get_port_state(port))
 {
  soc = open_sock_tcp(port);
  if(soc)
  {
   banner= recv_line(socket:soc, length:1024);
  }
 }
}

if(banner)
{
 if(ereg(pattern:".*[sS]endmail.*8\.((11\.[0-5])|12.*beta([0-9][^0-9]|1[0-8]))/.*", string:banner))
 	security_hole(port);
}
