#TRUSTED a5154da49e9fb2338f4fd84ee7b40488d1c0d489909228a81ec043726797d1d2d34f10aaceee3d47df5ffb24c4ffbb79281a4b812b688b1c9392c3e878ba48fe19a5aefc1506c24bd436a7d841e1edf63e24f6d078b9fa9394c0c2d9634998a602902187dd6b70e196069ed72e685f79d82636bf799dd65f876e4443a6b12ec221edda41166d307a1ca3aa26921de4eeb3296b2ea0fc87d91147740f644159c59b065f746672128701e281cbe877d6789de3ca981bba5cfe61e13bbc353166bd0051ec19ad8e4445ae2929e711651afe435aea061dcff112dcf4a718a6a09892379690383d358010f1dc435c95be016a4d94d69c76a30b40f6719afe72c06dd41e3156a5de87bbea5eee5b93bcfd3c608a6de3f81b0233e39fc47c3fab4e25913db55c9b6931d138dc9eef50bef9d28102d1036e17079649a0adab5c3a91374f53f5f0bb111e6e11f4de52b82255429524efff8c7621afe19ced4e236dab6bb1bca535c7b7b2ad34b0b25115ef696e1306ade3b854595a36abdea3716cbd0495d371781342e197a97d556890ea19fd67be99cfd8df21740c648da8bbea805413aac4bf67d3f094911d3c9f314f13a79a867f58c355c586549872cd7d1a5cdf13d50b690251aeb253527ddfda8ce5305a7b300999bc0c2ec13145883dc718710cbcc62cf6a71eb1f30015648238c91c7b591c0f59722767c89eb824cf3427f43c
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra")) exit(0);


if(description)
{
 script_id(15873);
 script_version ("1.1");
 name["english"] = "Hydra: HTTP";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find HTTP passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force HTTP authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 
 script_add_preference(name: "Web page (required) :", value: "/", type: "entry");

 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/logins_file", "Secret/hydra/passwords_file");
 script_require_ports("Services/www", 80);
 script_dependencies("hydra_options.nasl", "find_service.nes", "doublecheck_std_services.nasl");
 exit(0);
}

#

throrough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< throrough) exit(0);
logins = get_kb_item("Secret/hydra/logins_file");
passwd = get_kb_item("Secret/hydra/passwords_file");
if (logins == NULL || passwd == NULL) exit(0);

port = get_kb_item("Services/www");
if (! port) port = 80;
if (! get_port_state(port)) exit(0);

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
login_pass = get_kb_item("/tmp/hydra/login_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");
tr = get_kb_item("Transports/TCP/"+port);

i = 0;
argv[i++] = "hydra";
argv[i++] = "-p"; argv[i++] = port;
argv[i++] = "-L"; argv[i++] = logins;
argv[i++] = "-P"; argv[i++] = passwd;
s = "";
if (empty) s = "n";
if (login_pass) s+= "s";
if (s)
{
  argv[i++] = "-e"; argv[i++] = s;
}
if (exit_asap) argv[i++] = "-f";
if (tr >= ENCAPS_SSLv2) argv[i++] = "-S";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-w";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "http";

opt = script_get_preference("Web page (required) :");
if (! opt) exit(0);
argv[i++] = opt;

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*login: *(.*) password: *(.*)$');
  if (! isnull(v))
  {
    l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, 'username: ', l, '\tpassword: ', p, '\n');
    set_kb_item(name: 'Hydra/http/'+port, value: l + '\t' + p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to break the following HTTP accounts:\n' + report);
