/*

Copyright (C) 2000, 2001 Christian Kreibich <kreibich@aciri.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#ifdef LINUX
#define __FAVOR_BSD
#endif
#include <netinet/in_systm.h>
#include <netinet/in.h>
#include <net/if_arp.h>

#include <gtk/gtk.h>
#include <nd_arp.h>
#include <nd_packet.h>
#include <nd_globals.h>
#include <nd_misc.h>
#include <interface.h>
#include <support.h>


void    
arp_hrd(u_short hrd)
{
  ND_Packet     *p;
  
  for (nd_misc_pbar_reset(0), p = nd_trace_sel(); p;
       p = nd_packet_sel_next(p), nd_misc_pbar_inc())
    {
      if (nd_packet_has_protocol(p, ND_PROT_ARP))
	{
	  nd_packet_arp(p)->ar_hrd = htons(hrd);
	}
    }
  
  nd_misc_pbar_clear();  
  if (trace.p)
    nd_packet_set_arp(trace.p);
}


void    
arp_pro(u_short pro, ND_Protocol prot)
{
  ND_Packet     *p;

  for (nd_misc_pbar_reset(0), p = nd_trace_sel(); p;
       p = nd_packet_sel_next(p), nd_misc_pbar_inc())
    {
      if (prot == ND_PROT_ETHER &&
	  nd_packet_has_protocol(p, ND_PROT_ETHER))
	{
	  nd_packet_ethernet(p)->ether_type = htons(pro);
	}
      else if (nd_packet_has_protocol(p, ND_PROT_ARP))
	{
	  nd_packet_arp(p)->ar_pro = htons(pro);
	}
    }
  
  nd_misc_pbar_clear();  
  if (trace.p)
    {
      if (prot == ND_PROT_ETHER &&
	  nd_packet_has_protocol(trace.p, ND_PROT_ETHER))
	{
	  nd_packet_set_link_level(trace.p, 0);
	}
      else if (nd_packet_has_protocol(trace.p, ND_PROT_ARP))
	{
	  nd_packet_set_arp(trace.p);
	}
    }
}


void    
arp_hln(u_char hln)
{
  ND_Packet     *p;
  
  for (nd_misc_pbar_reset(0), p = nd_trace_sel(); p;
       p = nd_packet_sel_next(p), nd_misc_pbar_inc())
    {
      if (nd_packet_has_protocol(p, ND_PROT_ARP))
	{
	  nd_packet_arp(p)->ar_hln = hln;
	}
    }
  
  nd_misc_pbar_clear();  
  if (trace.p)
    nd_packet_set_arp(trace.p);
}


void    
arp_pln(u_char pln)
{
  ND_Packet     *p;
  
  for (nd_misc_pbar_reset(0), p = nd_trace_sel(); p;
       p = nd_packet_sel_next(p), nd_misc_pbar_inc())
    {
      if (nd_packet_has_protocol(p, ND_PROT_ARP))
	{
	  nd_packet_arp(p)->ar_pln = pln;
	}
    }
  
  nd_misc_pbar_clear();  
  if (trace.p)
    nd_packet_set_arp(trace.p);
}


void    
arp_op(u_short op)
{
  ND_Packet     *p;
  
  for (nd_misc_pbar_reset(0), p = nd_trace_sel(); p;
       p = nd_packet_sel_next(p), nd_misc_pbar_inc())
    {
      if (nd_packet_has_protocol(p, ND_PROT_ARP))
	{
	  nd_packet_arp(p)->ar_op = htons(op);
	}
    }
  
  nd_misc_pbar_clear();  
  if (trace.p)
    nd_packet_set_arp(trace.p);
}


void    
arp_sender_link(void)
{
  ND_Packet     *p;
  
  if ((p = nd_trace_sel()))
    {
      if (nd_packet_has_protocol(p, ND_PROT_ARP)     &&
	  nd_packet_arp(p)->ar_hrd == ARPHRD_ETHER)
	{
	  nd_misc_show_mac_dialog(_("Enter ARP source hardware addr:"), "arp_source_hard");	  	  
	}      
    }
}


void    
arp_sender_net(void)
{
  ND_Packet     *p;
  
  if ((p = nd_trace_sel()))
    {
      if (nd_packet_has_protocol(p, ND_PROT_ARP)     &&
	  nd_packet_arp(p)->ar_pro == ETHERTYPE_IP)
	{
	  
	}      
    }
}


void    
arp_target_link(void)
{
  ND_Packet     *p;
  
  if ((p = nd_trace_sel()))
    {
      if (nd_packet_has_protocol(p, ND_PROT_ARP)     &&
	  nd_packet_arp(p)->ar_hrd == ARPHRD_ETHER)
	{
	  nd_misc_show_mac_dialog(_("Enter ARP target hardware addr:"), "arp_target_hard");	  
	}      
    }
}


void    
arp_target_net(void)
{
  ND_Packet     *p;
  
  if ((p = nd_trace_sel()))
    {
      if (nd_packet_has_protocol(p, ND_PROT_ARP)     &&
	  nd_packet_arp(p)->ar_pro == ETHERTYPE_IP)
	{
	  
	}      
    }
}


