/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.expr.ApplyExp;
import gnu.expr.CanInline;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.LambdaExp;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.SetExp;

public class InlineCalls
extends ExpWalker {
    public static void inlineCalls(Expression exp) {
        InlineCalls walker = new InlineCalls();
        exp.walk(walker);
    }

    protected Expression walkApplyExp(ApplyExp exp) {
        Declaration decl;
        Object proc;
        super.walkApplyExp(exp);
        LambdaExp lambda2 = null;
        if (exp.func instanceof LambdaExp) {
            lambda2 = (LambdaExp)exp.func;
        }
        if (exp.func instanceof QuoteExp && (proc = ((QuoteExp)exp.func).getValue()) instanceof CanInline) {
            return ((CanInline)proc).inline(exp);
        }
        if (exp.func instanceof ReferenceExp && (decl = ((ReferenceExp)exp.func).binding) != null && !decl.getFlag(65536)) {
            Object proc2 = decl.getValue();
            if (proc2 instanceof LambdaExp) {
                lambda2 = (LambdaExp)proc2;
            }
            if (proc2 instanceof QuoteExp) {
                proc2 = ((QuoteExp)proc2).getValue();
            }
            if (proc2 instanceof CanInline) {
                return ((CanInline)proc2).inline(exp);
            }
        }
        if (lambda2 != null) {
            int args_length = exp.args.length;
            String msg = null;
            if (args_length < lambda2.min_args) {
                msg = "too few args for ";
            } else if (lambda2.max_args >= 0 && args_length > lambda2.max_args) {
                msg = "too many args " + args_length + " for ";
            }
            if (msg != null) {
                System.err.println("bad call: " + msg + lambda2.getName());
            }
        }
        return exp;
    }

    protected Expression walkSetExp(SetExp exp) {
        Expression declValue;
        Declaration decl = exp.binding;
        boolean updateNeeded = false;
        if (decl != null && (declValue = decl.getValue()) == exp.new_value) {
            updateNeeded = true;
        }
        exp.walkChildren(this);
        if (updateNeeded) {
            decl.value = exp.new_value;
            if (exp.new_value instanceof LambdaExp) {
                ((LambdaExp)exp.new_value).nameDecl = decl;
            }
        }
        return exp;
    }
}

