#include <fe/njamd.h>
#include <fe/gui/gui.h>
#include <fe/gui/mainwin.h>
#include "gtkextext/gtkextext.h"

static gint _njGUIDeleteEvent(GtkWidget* widget, GdkEvent* event,
		gpointer data);
static void _njGUIDestroyEvent(GtkWidget* widget, gpointer data);
static void _njGUIGetMainMenu(GtkWidget* window, GtkWidget** menubar);
static void _njGUICreateNotebook(NJGUINOTEBOOK* notebook);
static void _njGUICreateGDB(NJGUIGDB* gdb);

static GtkItemFactoryEntry menuItems[] =
{
	{ "/_File",                    NULL,         NULL, 0, "<Branch>" },
	{ "/File/_Start Debugging...", "<control>N", njGUIStartDebugging, 0, NULL },
	{ "/File/S_top Debugging",     "<control>S", njGUIStopDebugging, 0, NULL },
	{ "/File/sep1",                NULL,         NULL, 0, "<Separator>" },
	{ "/File/_Quit",               "<control>Q", njGUIExitProgram, 0, NULL },
	{ "/_Edit",                    NULL,         NULL, 0, "<Branch>" },
	{ "/Edit/Cu_t",                "<control>X", njGUICut, 0, NULL },
	{ "/Edit/_Copy",               "<control>C", njGUICopy, 0, NULL },
	{ "/Edit/_Paste",              "<control>V", njGUIPaste, 0, NULL },
	{ "/_Help",                    NULL,         NULL, 0, "<Branch>" },
	{ "/Help/_About",              NULL,         njGUIAbout, 0, NULL }
};

void njGUICreateMainWin(NJGUI* gui)
{
	gui->window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_signal_connect(GTK_OBJECT(gui->window), "delete_event",
		GTK_SIGNAL_FUNC(_njGUIDeleteEvent), NULL);
	gtk_signal_connect(GTK_OBJECT(gui->window), "destroy",
		GTK_SIGNAL_FUNC(_njGUIDestroyEvent), NULL);
	gtk_window_set_title(GTK_WINDOW(gui->window), NJAPPNAME);
	gtk_widget_set_usize(gui->window, 800, 600);

	gui->mainvbox = gtk_vbox_new(FALSE, 1);
	gtk_container_border_width(GTK_CONTAINER(gui->mainvbox), 1);
	gtk_container_add(GTK_CONTAINER(gui->window), gui->mainvbox);

	gui->menuhandle = gtk_handle_box_new();

	_njGUIGetMainMenu(gui->window, &(gui->menubar));
	gtk_container_add(GTK_CONTAINER(gui->menuhandle), gui->menubar);

	gtk_box_pack_start(GTK_BOX(gui->mainvbox), gui->menuhandle, FALSE, TRUE,
		0);

	gui->pane = gtk_vpaned_new();
	gtk_box_pack_start(GTK_BOX(gui->mainvbox), gui->pane, TRUE, TRUE, 0);

	_njGUICreateNotebook(&(gui->notebook));
	_njGUICreateGDB(&(gui->gdb));

	gtk_paned_add1(GTK_PANED(gui->pane), gui->notebook.main);
	gtk_paned_add2(GTK_PANED(gui->pane), gui->gdb.main);

	gui->statusbar = gtk_statusbar_new();
	gtk_box_pack_end(GTK_BOX(gui->mainvbox), gui->statusbar, FALSE, FALSE, 0);
}

static void _njGUICreateNotebook(NJGUINOTEBOOK* notebook)
{
	GtkWidget* text = gtk_extext_new();
	GtkWidget* text2 = gtk_extext_new();

	notebook->main = gtk_vbox_new(FALSE, 1);

	notebook->notebook = gtk_notebook_new();
	gtk_notebook_set_tab_pos(GTK_NOTEBOOK(notebook->notebook), GTK_POS_BOTTOM);

	notebook->tab1 = gtk_label_new("Source Code");
	notebook->tab2 = gtk_label_new("Interact");

	gtk_notebook_append_page(GTK_NOTEBOOK(notebook->notebook), text,
		notebook->tab1);
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook->notebook), text2,
		notebook->tab2);
	gtk_box_pack_start(GTK_BOX(notebook->main), notebook->notebook, TRUE,
		TRUE, 0);
}

static void _njGUICreateGDB(NJGUIGDB* gdb)
{
	gdb->main = gtk_table_new(2, 2, FALSE);

	gdb->text = gtk_extext_new();
	gtk_table_attach(GTK_TABLE(gdb->main), gdb->text, 0, 1, 0, 1,
		GTK_FILL | GTK_SHRINK | GTK_EXPAND,
		GTK_FILL | GTK_SHRINK | GTK_EXPAND, 0, 0);
	
	gdb->vscrollbar = gtk_vscrollbar_new(GTK_EXTEXT(gdb->text)->vadj);
	gtk_table_attach(GTK_TABLE(gdb->main), gdb->vscrollbar, 1, 2, 0, 1,
		0, GTK_FILL, 0, 0);

	gdb->hscrollbar = gtk_hscrollbar_new(GTK_EXTEXT(gdb->text)->hadj);
	gtk_table_attach(GTK_TABLE(gdb->main), gdb->hscrollbar, 0, 1, 1, 2,
		GTK_FILL, 0, 0, 0);
}

static gint _njGUIDeleteEvent(GtkWidget* widget, GdkEvent* event,
		gpointer data)
{
	return FALSE;  /* send a destroy event.  TRUE -> don't destroy */
}

static void _njGUIDestroyEvent(GtkWidget* widget, gpointer data)
{
	njGUIExitProgram(NULL, (gpointer) EXIT_SUCCESS);
}

static void _njGUIGetMainMenu(GtkWidget* window, GtkWidget** menubar)
{
	GtkItemFactory* itemFactory;
	GtkAccelGroup*  accelGroup;
	int nmenuItems = sizeof(menuItems) / sizeof(menuItems[0]);

	accelGroup = gtk_accel_group_new();
	itemFactory = gtk_item_factory_new(GTK_TYPE_MENU_BAR, "<main>",
			accelGroup);
	
	gtk_item_factory_create_items(itemFactory, nmenuItems, menuItems, NULL);

	gtk_window_add_accel_group(GTK_WINDOW(window), accelGroup);

	if (menubar)
		*menubar = gtk_item_factory_get_widget(itemFactory, "<main>");
}
