/** 
 * @file util.c 
 * Contains system utility fcns.
 *
 * Functions related to NJAMD's internal data structures and info gathering
 * cababilities lie here.
 *
 * Copyright (C) 2000 by Mike Perry.
 * Distributed WITHOUT WARRANTY under the GPL. See COPYING for details.
 * 
 */
#include <lib/util.h>
#include <lib/output.h>
#include <stdio.h>


/** 
 * @FIXME This can be done without a loop.. but I forget how.
 * I've also been told the loop is faster, due to pipelining.. But then this 
 * was by someone who chouldn't remember how to do the constant-time way 
 * either, so... ;) */
int __nj_log2(int x)
{
	int log;
	/* Only care about the low 8 bits of x */
	for (log=0; log < 8; log++)
		if(x>>log & 1)
			return log;

	/* Hrmm.. should print out a warning here */
	__nj_eprintf("Invalid alignment: %d. Max is 128, Min is 1.\n"
				 "Some hackery can increase the maximum alignment\n"
				 "Mail njamd-devel@lists.sourceforge.net if this is needed\n");

	/* Yes, 0. 2^0 = 1, silly */
	return 0;
}

/**@{ @name Thread UNSAFE
 * @FIXME: the following functions are NOT threadsafe.. They are just error
 * reporting functions though. There really is no danger, in that they are
 * only called when something is ALREADY fucked up 
 */

/**
 * Converts integer to string
 * @param i Int to convert
 * @returns Statically allocated character pointer
 */
char *__nj_itoa(int i)
{
	static char a[16];
	snprintf(a, 15, "%d", i);
	return a;
}

/**
 * Converts pointer to string
 * @param i pointer to convert
 * @returns Statically allocated character pointer
 */
char *__nj_ptoa(void *i)
{
	static char a[16];
	snprintf(a, 15, "0x%lx", (u_long)i);
	return a;
}


/*@}*/
// vim:ts=4
