var tape = require("tape"),
    shape = require("../../");

tape("stackOrderInsideOut(series) returns an order by appearance", function(test) {
  test.deepEqual(shape.stackOrderInsideOut([
    [[0, 0], [0, 0], [0, 0], [0, 0], [0, 0], [0, 0], [0, 1]],
    [[0, 0], [0, 0], [0, 0], [0, 0], [0, 0], [0, 2], [0, 0]],
    [[0, 0], [0, 0], [0, 0], [0, 0], [0, 3], [0, 0], [0, 0]],
    [[0, 0], [0, 0], [0, 0], [0, 4], [0, 0], [0, 0], [0, 0]],
    [[0, 0], [0, 0], [0, 5], [0, 0], [0, 0], [0, 0], [0, 0]],
    [[0, 0], [0, 6], [0, 0], [0, 0], [0, 0], [0, 0], [0, 0]],
    [[0, 7], [0, 0], [0, 0], [0, 0], [0, 0], [0, 0], [0, 0]]
  ]), [2, 3, 6, 5, 4, 1, 0]);
  test.end();
});

tape("stackOrderInsideOut(series) treats NaN values as zero", function(test) {
  test.deepEqual(shape.stackOrderInsideOut([
    [[0, 0], [0, NaN], [0, 0], [0, 0], [0, 0], [0, 0], [0, 1]],
    [[0, 0], [0, 0], [0, NaN], [0, 0], [0, 0], [0, 2], [0, 0]],
    [[0, 0], [0, 0], [0, 0], [0, 0], [0, 3], [0, 0], [0, 0]],
    [[0, 0], [0, 0], [0, 0], [0, 4], [0, NaN], [0, 0], [0, 0]],
    [[0, 0], [0, 0], [0, 5], [0, 0], [0, 0], [0, NaN], [0, 0]],
    [[0, NaN], [0, 6], [0, 0], [0, NaN], [0, 0], [0, 0], [0, 0]],
    [[0, 7], [0, NaN], [0, 0], [0, 0], [0, 0], [0, 0], [0, 0]]
  ]), [2, 3, 6, 5, 4, 1, 0]);
  test.end();
});
