/*
 * (C) Copyright 1996-2016 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.
 */

// @file   HttpHandle.h
// @author Piotr Kuchta - ECMWF 27 Oct 2016

#ifndef odc_data_HttpFileHandle_h
#define odc_data_HttpFileHandle_h

#include "eckit/io/TCPHandle.h"

namespace odc {

class HttpHandle : public eckit::DataHandle {
public:
	HttpHandle(const std::string& url);
	~HttpHandle();
// -- Overridden methods
	// From DataHandle
    virtual eckit::Length openForRead();
    virtual void openForWrite(const eckit::Length&);
    virtual void openForAppend(const eckit::Length&);

	virtual long read(void*,long);
	virtual long write(const void*,long);
	virtual void close();
	virtual void print(std::ostream&) const;

	// From Streamable
    virtual void encode(eckit::Stream&) const;

    static std::string parseHost(const std::string&);
    static int parsePort(const std::string&);

private:
	const std::string url_;
    eckit::TCPHandle tcp_;
};

} // namespace odc

#endif
