"""
OnionShare | https://onionshare.org/

Copyright (C) 2017 Micah Lee <micah@micahflee.com>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
"""
import tempfile
import os


class MockSubprocess():
    def __init__(self):
        self.last_call = None

    def call(self, args):
        self.last_call = args

    def last_call_args(self):
        return self.last_call


def write_tempfile(text):
    path = os.path.join(tempfile.mkdtemp(), "/test-file.txt")
    with open(path, "w") as f:
        f.write(text)
    return path
