///////////////////////////////////////////////////////////////////////////////
// $Id: SampleCollection.cxx,v 1.1 1995/01/08 06:48:08 bmott Exp $
///////////////////////////////////////////////////////////////////////////////
//
// SampleCollection.hxx - SampleCollection class
//
//
// Bradford W. Mott
// Copyright (C) 1995
// January 4,1995
//
///////////////////////////////////////////////////////////////////////////////
// $Log: SampleCollection.cxx,v $
// Revision 1.1  1995/01/08  06:48:08  bmott
// Initial revision
//
///////////////////////////////////////////////////////////////////////////////

#include <assert.h>
#include <string.h>
#include "SampleCollection.hxx"

///////////////////////////////////////////////////////////////////////////////
// Constructor
///////////////////////////////////////////////////////////////////////////////
SampleCollection::SampleCollection(unsigned char* sampleData[])
{
  // Create a sample for every "raw" sample
  for(int t=0; sampleData[t] != (unsigned char*)0; ++t)
  {
    // Create sprite
    Sample* sample = new Sample(sampleData[t]);

    // Add it to my linked list
    ListOfSamples.append(sample);
  }
}

///////////////////////////////////////////////////////////////////////////////
// Answer the sample for the given name or (Sample*)0 if it doesn't exist
///////////////////////////////////////////////////////////////////////////////
Sample* SampleCollection::getByName(const char* name)
{
  Sample* p = ListOfSamples.first();
  while(p != (Sample*)0)
  {
    if(strcmp(p->name(), name) == 0)
      return(p);

    p = ListOfSamples.next();
  }

  return((Sample*)0);
}

