// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepAlgo_TopOpe_HeaderFile
#define _BRepAlgo_TopOpe_HeaderFile

#ifndef _BOPTools_PDSFiller_HeaderFile
#include <BOPTools_PDSFiller.hxx>
#endif
#ifndef _BOP_PBuilder_HeaderFile
#include <BOP_PBuilder.hxx>
#endif
#ifndef _Handle_BOP_HistoryCollector_HeaderFile
#include <Handle_BOP_HistoryCollector.hxx>
#endif
#ifndef _Handle_BRepAlgo_EdgeConnector_HeaderFile
#include <Handle_BRepAlgo_EdgeConnector.hxx>
#endif
#ifndef _TopoDS_Shape_HeaderFile
#include <TopoDS_Shape.hxx>
#endif
#ifndef _TopAbs_State_HeaderFile
#include <TopAbs_State.hxx>
#endif
#ifndef _TopTools_ListOfShape_HeaderFile
#include <TopTools_ListOfShape.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _TopoDS_Wire_HeaderFile
#include <TopoDS_Wire.hxx>
#endif
#ifndef _TColStd_ListOfInteger_HeaderFile
#include <TColStd_ListOfInteger.hxx>
#endif
#ifndef _TopTools_DataMapOfShapeShape_HeaderFile
#include <TopTools_DataMapOfShapeShape.hxx>
#endif
#ifndef _TColStd_SetOfInteger_HeaderFile
#include <TColStd_SetOfInteger.hxx>
#endif
class BOP_HistoryCollector;
class BRepAlgo_EdgeConnector;
class TopoDS_Shape;
class TopTools_ListOfShape;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


class BRepAlgo_TopOpe  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT BRepAlgo_TopOpe();

//! Purge la  structure de donne  interne, y compris  les <br>
//!          Shapes de Load(). <br>
Standard_EXPORT   void Init() ;

//! Charge le shape dans la SD. <br>
//! <br>
Standard_EXPORT   void Load(const TopoDS_Shape& S) ;

//! Charge les deux shapes dans la SD sans les intersecter. <br>
Standard_EXPORT   void Load(TopoDS_Shape& S1,TopoDS_Shape& S2) ;

//! Intersecte les deux shapes en entre et charge la SD avec <br>
//!          leur intersection. Clear le TopOpeBRepBuild_HBuilder si <br>
//!          besoin <br>
Standard_EXPORT   void Intersect() ;

//! Intersecte les faces contenues dans les deux shapes donnes <br>
//!          et charge la SD avec. Clear le TopOpeBRepBuild_HBuilder <br>
//!          si besoin <br>
Standard_EXPORT   void Intersect(const TopoDS_Shape& S1,const TopoDS_Shape& S2) ;


Standard_EXPORT   void ToCompleteIntersection() ;

//! return tous les compounds d'edges connexes de section <br>
//!          contenu dans la DS <br>
Standard_EXPORT  const TopTools_ListOfShape& GetSectionEdgeSet() ;

//! Invalider une ligne de section complte. Ensemble <br>
//!          d'Edge connexes par Vertex. Peut-etre un Wire. Peut <br>
//!          etre un ensemble d'Edge connexe ne formant pas un <br>
//!          Wire standard. <br>
Standard_EXPORT   void SuppressEdgeSet() ;


Standard_EXPORT  const TopoDS_Shape& Merge(const TopAbs_State state1,const TopAbs_State state2) ;


Standard_EXPORT  const TopoDS_Shape& Merge(const TopAbs_State state1) ;


Standard_EXPORT   Standard_Boolean PaveBlocksNotEmpty() ;


Standard_EXPORT  const BOP_PBuilder& Builder() const;


Standard_EXPORT  const BOPTools_PDSFiller& DSFiller() const;


Standard_EXPORT  const Handle_BOP_HistoryCollector& History() const;


Standard_EXPORT   void Destroy() ;
Standard_EXPORT virtual ~BRepAlgo_TopOpe(){Destroy();}





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
BOPTools_PDSFiller myDSFiller;
BOP_PBuilder myBuilder;
Handle_BOP_HistoryCollector myHistory;
Handle_BRepAlgo_EdgeConnector myEC;
TopoDS_Shape myS1;
TopoDS_Shape myS2;
TopAbs_State myState1;
TopAbs_State myState2;
TopTools_ListOfShape myListOfCompoundOfEdgeConnected;
TopTools_ListOfShape myCurrentList;
Standard_Boolean myRecomputeBuilderIsDone;
Standard_Boolean myGetSectionIsDone;
TopoDS_Shape myResultShape;
TopoDS_Wire myWire;
TopTools_ListOfShape myListOfVertex;
TopTools_ListOfShape myModified;
TopoDS_Shape myEmptyShape;
TopTools_ListOfShape myEmptyListOfShape;
TColStd_ListOfInteger myEmptyListOfInteger;
TopTools_DataMapOfShapeShape myCompoundWireMap;
TColStd_SetOfInteger mySetOfKeepPoint;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
