// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepBuilderAPI_HeaderFile
#define _BRepBuilderAPI_HeaderFile

#ifndef _Handle_Geom_Plane_HeaderFile
#include <Handle_Geom_Plane.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class Geom_Plane;
class BRepBuilderAPI_Command;
class BRepBuilderAPI_MakeShape;
class BRepBuilderAPI_MakeVertex;
class BRepBuilderAPI_MakeEdge;
class BRepBuilderAPI_MakeEdge2d;
class BRepBuilderAPI_MakePolygon;
class BRepBuilderAPI_MakeFace;
class BRepBuilderAPI_FindPlane;
class BRepBuilderAPI_Sewing;
class BRepBuilderAPI_MakeWire;
class BRepBuilderAPI_MakeShell;
class BRepBuilderAPI_MakeSolid;
class BRepBuilderAPI_ModifyShape;
class BRepBuilderAPI_Transform;
class BRepBuilderAPI_NurbsConvert;
class BRepBuilderAPI_GTransform;
class BRepBuilderAPI_Copy;
class BRepBuilderAPI_Collect;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! The  BRepBuilderAPI  package   provides  an   Application <br>
//!          Programming Interface  for the BRep  topology data <br>
//!          structure. <br>
//! <br>
//!          The API is a set of classes aiming to provide : <br>
//! <br>
//!          * High level and simple calls  for the most common <br>
//!          operations. <br>
//! <br>
//!          *    Keeping   an   access  on    the    low-level <br>
//!          implementation of high-level calls. <br>
//! <br>
//!          * Examples  of programming of high-level operations <br>
//!          from low-level operations. <br>
//! <br>
//!          * A complete coverage of modelling : <br>
//! <br>
//!             - Creating vertices ,edges, faces, solids. <br>
//! <br>
//!             - Sweeping operations. <br>
//! <br>
//!             - Boolean operations. <br>
//! <br>
//!             - Global properties computation. <br>
class BRepBuilderAPI  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Sets    the current plane. <br>
Standard_EXPORT static  void Plane(const Handle(Geom_Plane)& P) ;

//! Returns the current plane. <br>
//! <br>
Standard_EXPORT static const Handle_Geom_Plane& Plane() ;

//! Sets the default precision.  The current Precision <br>
//!          is returned. <br>
Standard_EXPORT static  void Precision(const Standard_Real P) ;

//! Returns the default precision. <br>
Standard_EXPORT static  Standard_Real Precision() ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //

friend class BRepBuilderAPI_Command;
friend class BRepBuilderAPI_MakeShape;
friend class BRepBuilderAPI_MakeVertex;
friend class BRepBuilderAPI_MakeEdge;
friend class BRepBuilderAPI_MakeEdge2d;
friend class BRepBuilderAPI_MakePolygon;
friend class BRepBuilderAPI_MakeFace;
friend class BRepBuilderAPI_FindPlane;
friend class BRepBuilderAPI_Sewing;
friend class BRepBuilderAPI_MakeWire;
friend class BRepBuilderAPI_MakeShell;
friend class BRepBuilderAPI_MakeSolid;
friend class BRepBuilderAPI_ModifyShape;
friend class BRepBuilderAPI_Transform;
friend class BRepBuilderAPI_NurbsConvert;
friend class BRepBuilderAPI_GTransform;
friend class BRepBuilderAPI_Copy;
friend class BRepBuilderAPI_Collect;

};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
