// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepClass_FaceClassifier_HeaderFile
#define _BRepClass_FaceClassifier_HeaderFile

#ifndef _BRepClass_FClassifier_HeaderFile
#include <BRepClass_FClassifier.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class BRepClass_FaceExplorer;
class gp_Pnt2d;
class TopoDS_Face;
class gp_Pnt;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Provides Constructors. <br>
class BRepClass_FaceClassifier  : public BRepClass_FClassifier {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Empty constructor, undefined algorithm. <br>
Standard_EXPORT BRepClass_FaceClassifier();

//! Creates an algorithm to classify the Point  P with <br>
//!          Tolerance <T> on the face described by <F>. <br>
Standard_EXPORT BRepClass_FaceClassifier(BRepClass_FaceExplorer& F,const gp_Pnt2d& P,const Standard_Real Tol);

//! Creates an algorithm to classify the Point  P with <br>
//!          Tolerance <T> on the face <F>. <br>
Standard_EXPORT BRepClass_FaceClassifier(const TopoDS_Face& F,const gp_Pnt2d& P,const Standard_Real Tol);

//! Classify  the Point  P  with  Tolerance <T> on the <br>
//!          face described by <F>. <br>
Standard_EXPORT   void Perform(const TopoDS_Face& F,const gp_Pnt2d& P,const Standard_Real Tol) ;

//! Creates an algorithm to classify the Point  P with <br>
//!          Tolerance <T> on the face described by <F>. <br>
Standard_EXPORT BRepClass_FaceClassifier(BRepClass_FaceExplorer& F,const gp_Pnt& P,const Standard_Real Tol);

//! Creates an algorithm to classify the Point  P with <br>
//!          Tolerance <T> on the face <F>. <br>
Standard_EXPORT BRepClass_FaceClassifier(const TopoDS_Face& F,const gp_Pnt& P,const Standard_Real Tol);

//! Classify  the Point  P  with  Tolerance <T> on the <br>
//!          face described by <F>. <br>
Standard_EXPORT   void Perform(const TopoDS_Face& F,const gp_Pnt& P,const Standard_Real Tol) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
