// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepOffsetAPI_MakePipeShell_HeaderFile
#define _BRepOffsetAPI_MakePipeShell_HeaderFile

#ifndef _Handle_BRepFill_PipeShell_HeaderFile
#include <Handle_BRepFill_PipeShell.hxx>
#endif
#ifndef _BRepPrimAPI_MakeSweep_HeaderFile
#include <BRepPrimAPI_MakeSweep.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Law_Function_HeaderFile
#include <Handle_Law_Function.hxx>
#endif
#ifndef _BRepBuilderAPI_PipeError_HeaderFile
#include <BRepBuilderAPI_PipeError.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _BRepBuilderAPI_TransitionMode_HeaderFile
#include <BRepBuilderAPI_TransitionMode.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class BRepFill_PipeShell;
class Standard_DomainError;
class StdFail_NotDone;
class TopoDS_Wire;
class gp_Ax2;
class gp_Dir;
class TopoDS_Shape;
class TopoDS_Vertex;
class Law_Function;
class TopTools_ListOfShape;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This class provides for a framework to construct a shell <br>
//! or a solid along a spine consisting in a wire. <br>
//! To produce a solid, the initial wire must be closed. <br>
//! Two approaches are used: <br>
//! - definition by section <br>
//!   - by a section and a scaling law <br>
//!   - by addition of successive intermediary sections <br>
//! - definition by sweep mode. <br>
//!   - pseudo-Frenet <br>
//!  - constant <br>
//!  - binormal constant <br>
//!  - normal defined by a surface support <br>
//!  - normal defined by a guiding contour. <br>
//!  The two global approaches can also be combined. <br>
//!  You can also close the surface later in order to form a solid. <br>
//!  Warning: In this version some limitation exist <br>
//!   -- We can add only 1 Section (else Standard_NotImplemented is raised <br>
//!   -- Mode with auxilary spine is incompatible with hometetic laws <br>
//!   -- Mode with auxilary spine and keep contact produce only CO surface. <br>
//!   -- Transition treatement is implemented only with the option <BRepBuilderAPI_Transformed> <br>
//!  Normaly all these limitations have to be deleted in mext version. <br>
class BRepOffsetAPI_MakePipeShell  : public BRepPrimAPI_MakeSweep {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Constructs the shell-generating framework defined by the wire Spine. <br>//! Sets an sweep's mode <br>
//!         If no mode are setted, the mode use in MakePipe is used <br>
Standard_EXPORT BRepOffsetAPI_MakePipeShell(const TopoDS_Wire& Spine);

//! Sets a Frenet or a CorrectedFrenet trihedron <br>
//!          to  perform  the  sweeping <br>
//!	 If IsFrenet is false, a corrected Frenet trihedron is used. <br>
Standard_EXPORT   void SetMode(const Standard_Boolean IsFrenet = Standard_False) ;

//! Sets  a  fixed  trihedron  to  perform  the  sweeping <br>
//!         all sections will be parallel. <br>
Standard_EXPORT   void SetMode(const gp_Ax2& Axe) ;

//! Sets a fixed BiNormal  direction to perform the -- <br>
//!             sweeping.   Angular   relations   beetween  the <br>
//!          section(s) and <BiNormal> will be constant <br>
Standard_EXPORT   void SetMode(const gp_Dir& BiNormal) ;

//! Sets support to the spine to define the BiNormal of <br>
//!          the trihedron, like the normal  to the surfaces. <br>
//!  Warning:  To be effective, Each  edge of the <spine> must <br>
//!          have an representaion on one face of<SpineSupport> <br>
Standard_EXPORT   Standard_Boolean SetMode(const TopoDS_Shape& SpineSupport) ;

//! Sets  an  auxiliary  spine  to  define  the Normal <br>
//!  For  each  Point  of  the  Spine  P,  an  Point  Q  is  evalued <br>
//!    on  <AuxiliarySpine> <br>
//! If <CurvilinearEquivalence> <br>
//!   Q split <AuxiliarySpine> with  the  same  length ratio <br>
//!   than P split  <Spline>. <br>
//! Else  the  plan  define  by  P  and  the  tangent  to  the  <Spine> <br>
//!       intersect <AuxiliarySpine> in Q. <br>
//! If <KeepContact> the  Normal  is  defined to  assume like  the  sweeped <br>
//!                  section is  in  contact to  the  <AuxiliarySpine> <br>
//! Else  the  Normal  is  defined  by the vector  PQ. <br>//! Give section to sweep. <br>
//! Possibilities are : <br>
//!	- Give one or sevral section <br>
//!     - Give one profile and an homotetic law. <br>
//!     - Automatic compute of correspondance beetween spine, and section <br>
//!                 on the sweeped shape <br>
//!     - correspondance beetween spine, and section on the sweeped shape <br>
//!       defined by a vertex of the spine <br>
Standard_EXPORT   void SetMode(const TopoDS_Wire& AuxiliarySpine,const Standard_Boolean CurvilinearEquivalence,const Standard_Boolean KeepContact = Standard_False) ;

//! Adds the section Profile to this framework. First and last <br>
//! sections may be punctual, so the shape Profile may be <br>
//! both wire and vertex. Correspondent point on spine is <br>
//! computed automatically. <br>
//! If WithContact is true, the section is translated to be in <br>
//! contact with the spine. <br>
//!  If WithCorrection is true, the section is rotated to be <br>
//! orthogonal to the spine?s tangent in the correspondent <br>
//! point. This option has no sense if the section is punctual <br>
//! (Profile is of type TopoDS_Vertex). <br>
Standard_EXPORT   void Add(const TopoDS_Shape& Profile,const Standard_Boolean WithContact = Standard_False,const Standard_Boolean WithCorrection = Standard_False) ;

//! Adds the section Profile to this framework. <br>
//! Correspondent point on the spine is given by Location. <br>
//! Warning: <br>
//! To be effective, it is not recommended to combine methods Add and SetLaw. <br>
Standard_EXPORT   void Add(const TopoDS_Shape& Profile,const TopoDS_Vertex& Location,const Standard_Boolean WithContact = Standard_False,const Standard_Boolean WithCorrection = Standard_False) ;

//! Sets the evolution law defined by the wire Profile with <br>
//! its position (Location, WithContact, WithCorrection <br>
//! are the same options as in methods Add) and a <br>
//! homotetic law defined by the function L. <br>
//! Warning: <br>
//! To be effective, it is not recommended to combine methods Add and SetLaw. <br>
Standard_EXPORT   void SetLaw(const TopoDS_Shape& Profile,const Handle(Law_Function)& L,const Standard_Boolean WithContact = Standard_False,const Standard_Boolean WithCorrection = Standard_False) ;

//! Sets the evolution law defined by the wire Profile with <br>
//! its position (Location, WithContact, WithCorrection <br>
//! are the same options as in methods Add) and a <br>
//! homotetic law defined by the function L. <br>
//! Warning: <br>
//! To be effective, it is not recommended to combine methods Add and SetLaw. <br>
Standard_EXPORT   void SetLaw(const TopoDS_Shape& Profile,const Handle(Law_Function)& L,const TopoDS_Vertex& Location,const Standard_Boolean WithContact = Standard_False,const Standard_Boolean WithCorrection = Standard_False) ;

//! Removes the section Profile from this framework. <br>
Standard_EXPORT   void Delete(const TopoDS_Shape& Profile) ;

//! Returns true if this tool object is ready to build the <br>
//! shape, i.e. has a definition for the wire section Profile. <br>
Standard_EXPORT   Standard_Boolean IsReady() const;

//! Get a status, when Simulate or Build failed.       It can be <br>
//!      BRepBuilderAPI_PipeDone, <br>
//!      BRepBuilderAPI_PipeNotDone, <br>
//!      BRepBuilderAPI_PlaneNotIntersectGuide, <br>
//!      BRepBuilderAPI_ImpossibleContact. <br>
Standard_EXPORT   BRepBuilderAPI_PipeError GetStatus() const;

//! Sets the following tolerance values <br>
//! - 3D tolerance Tol3d <br>
//! - boundary tolerance BoundTol <br>
//! - angular tolerance TolAngular. <br>
Standard_EXPORT   void SetTolerance(const Standard_Real Tol3d = 1.0e-4,const Standard_Real BoundTol = 1.0e-4,const Standard_Real TolAngular = 1.0e-2) ;

//! Sets the transition mode to manage discontinuities on <br>
//! the swept shape caused by fractures on the spine. The <br>
//! transition mode can be BRepBuilderAPI_Transformed <br>
//! (default value), BRepBuilderAPI_RightCorner, <br>
//! BRepBuilderAPI_RoundCorner: <br>
//!      -              RepBuilderAPI_Transformed: <br>
//!           discontinuities are treated by <br>
//!           modification of the sweeping mode. The <br>
//!           pipe is "transformed" at the fractures of <br>
//!           the spine. This mode assumes building a <br>
//!           self-intersected shell. <br>
//! -              BRepBuilderAPI_RightCorner: <br>
//!           discontinuities are treated like right <br>
//!           corner. Two pieces of the pipe <br>
//!           corresponding to two adjacent <br>
//!           segments of the spine are extended <br>
//!           and intersected at a fracture of the spine. <br>
//! -              BRepBuilderAPI_RoundCorner: <br>
//!           discontinuities are treated like round <br>
//!           corner. The corner is treated as rotation <br>
//!           of the profile around an axis which <br>
//!           passes through the point of the spine?s <br>
//!           fracture. This axis is based on cross <br>
//!           product of directions tangent to the <br>
//!      adjacent segments of the spine at their common point. <br>
//! Warnings <br>
//! The mode BRepBuilderAPI_RightCorner provides a <br>
//! valid result if intersection of two pieces of the pipe <br>
//! (corresponding to two adjacent segments of the spine) <br>
//! in the neighborhood of the spine?s fracture is <br>
//! connected and planar. This condition can be violated if <br>
//! the spine is non-linear in some neighborhood of the <br>
//! fracture or if the profile was set with a scaling law. <br>
//! The last mode, BRepBuilderAPI_RoundCorner, will <br>
//! assuredly provide a good result only if a profile was set <br>
//! with option WithCorrection = True, i.e. it is strictly <br>
//! orthogonal to the spine. <br>
Standard_EXPORT   void SetTransitionMode(const BRepBuilderAPI_TransitionMode Mode = BRepBuilderAPI_Transformed) ;

//! Simulates the resulting shape by calculating its <br>
//! cross-sections. The spine is devided by this <br>
//! cross-sections into (NumberOfSection - 1) equal <br>
//! parts, the number of cross-sections is <br>
//! NumberOfSection. The cross-sections are wires and <br>
//! they are returned in the list Result. <br>
//! This gives a rapid preview of the resulting shape, <br>
//! which will be obtained using the settings you have provided. <br>
//! Raises  NotDone if  <me> it is not Ready <br>
Standard_EXPORT   void Simulate(const Standard_Integer NumberOfSection,TopTools_ListOfShape& Result) ;

//! Builds the resulting shape (redefined from MakeShape). <br>
Standard_EXPORT virtual  void Build() ;

//! Transforms the sweeping Shell in Solid. <br>
//!          If a propfile is not closed returns False <br>
Standard_EXPORT   Standard_Boolean MakeSolid() ;

//! Returns the  TopoDS  Shape of the bottom of the sweep. <br>
Standard_EXPORT virtual  TopoDS_Shape FirstShape() ;

//! Returns the TopoDS Shape of the top of the sweep. <br>
Standard_EXPORT virtual  TopoDS_Shape LastShape() ;

//! Returns a list of new shapes generated from the shape <br>
//! S by the shell-generating algorithm. <br>
//! This function is redefined from BRepOffsetAPI_MakeShape::Generated. <br>
//! S can be an edge of the given Spine (see Constructor), <br>
//! it can be an edge or a boundary vertex of a shape <br>
//! returned by the method FirstShape(), it can also be a <br>
//! Profile (see method Add()) closest to the beginning or <br>
//! the end of the Spine. <br>
//! If S is an edge of the given Spine, then method <br>
//! Generated() returns a list of generated faces and a list <br>
//! of edges from a free boundary (if it exists) of the <br>
//! resulting shell. <br>
//! If S is an edge of the start shape (see FirstShape()), <br>
//! method Generated() returns a list of faces generated <br>
//! along the whole spine from the given edge. <br>
//! If S is a boundary vertex of the start shape (see <br>
//! FirstShape()), method Generated() returns a list of <br>
//! edges from the free boundary of the resulting shell, <br>
//! generated along the whole spine. <br>
//! If S is a Profile closest to the beginning of the Spine, <br>
//! method Generated() returns the start shape, that can <br>
//! also be obtained by method FirstShape(). <br>
//! If S is a Profile closest to the end of the Spine, method <br>
//! Generated() returns the end shape, that can also be <br>
//! obtained by method LastShape(). <br>
Standard_EXPORT virtual const TopTools_ListOfShape& Generated(const TopoDS_Shape& S) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_BRepFill_PipeShell myPipe;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
