// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _DBRep_HideData_HeaderFile
#define _DBRep_HideData_HeaderFile

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _gp_Trsf_HeaderFile
#include <gp_Trsf.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _HLRBRep_ListOfBPoint_HeaderFile
#include <HLRBRep_ListOfBPoint.hxx>
#endif
#ifndef _TopoDS_Shape_HeaderFile
#include <TopoDS_Shape.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class gp_Trsf;
class TopoDS_Shape;
class Draw_Display;
class Draw_Color;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This  class stores all the informations concerning <br>
//!          hidden lines on a view. <br>
//! <br>
//!          * View number <br>
//!          * Matrix of projection <br>
//!          * Type of projection, focal <br>
//!          * Arrays of 3d points <br>
//! <br>
//!          A drawable shape contains a  list of such  objects <br>
//!          to store  the  hidden lines  for  each view.   The <br>
//!          IsSame method is  used  to check if   hidden lines <br>
//!          must be recompiled. <br>
class DBRep_HideData  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT DBRep_HideData();

//! ViewId is the view number <br>
//!          TProj the projection <br>
//!          Focal <= 0 means parallel projection <br>
//!          Alg : the hidden lines <br>
Standard_EXPORT   void Set(const Standard_Integer ViewId,const gp_Trsf& TProj,const Standard_Real Focal,const TopoDS_Shape& S,const Standard_Real ang) ;

  Standard_Integer ViewId() const;

  Standard_Real Angle() const;

//! Returns True if the projection is the same <br>
Standard_EXPORT   Standard_Boolean IsSame(const gp_Trsf& TProj,const Standard_Real Focla) const;


Standard_EXPORT   void DrawOn(Draw_Display& D,const Standard_Boolean withRg1,const Standard_Boolean withRgN,const Standard_Boolean withHid,const Draw_Color& VisCol,const Draw_Color& HidCol) ;

//! Returns the subshape touched by the last pick. <br>
Standard_EXPORT  const TopoDS_Shape& LastPick() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Integer myView;
gp_Trsf myTrsf;
Standard_Real myFocal;
HLRBRep_ListOfBPoint myBiPntVis;
HLRBRep_ListOfBPoint myBiPntHid;
TopoDS_Shape myPickShap;
Standard_Real myAngle;


};


#include <DBRep_HideData.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
