// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _GeomFill_Boundary_HeaderFile
#define _GeomFill_Boundary_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_GeomFill_Boundary_HeaderFile
#include <Handle_GeomFill_Boundary.hxx>
#endif

#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class gp_Pnt;
class gp_Vec;


//! Root class to define a boundary  which will form part of a <br>
//! contour around a gap requiring filling. <br>
//! The GeomFill package provides two classes to define constrained boundaries: <br>
//! -   GeomFill_SimpleBound to define an unattached boundary <br>
//! -   GeomFill_BoundWithSurf to define a boundary attached to a surface. <br>
//!   These objects are used to define the boundaries for a <br>
//! GeomFill_ConstrainedFilling framework. <br>
class GeomFill_Boundary : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 


Standard_EXPORT virtual  gp_Pnt Value(const Standard_Real U) const = 0;


Standard_EXPORT virtual  void D1(const Standard_Real U,gp_Pnt& P,gp_Vec& V) const = 0;


Standard_EXPORT virtual  Standard_Boolean HasNormals() const;


Standard_EXPORT virtual  gp_Vec Norm(const Standard_Real U) const;


Standard_EXPORT virtual  void D1Norm(const Standard_Real U,gp_Vec& N,gp_Vec& DN) const;


Standard_EXPORT virtual  void Reparametrize(const Standard_Real First,const Standard_Real Last,const Standard_Boolean HasDF,const Standard_Boolean HasDL,const Standard_Real DF,const Standard_Real DL,const Standard_Boolean Rev)  = 0;


Standard_EXPORT   void Points(gp_Pnt& PFirst,gp_Pnt& PLast) const;


Standard_EXPORT virtual  void Bounds(Standard_Real& First,Standard_Real& Last) const = 0;


Standard_EXPORT virtual  Standard_Boolean IsDegenerated() const = 0;


Standard_EXPORT   Standard_Real Tol3d() const;


Standard_EXPORT   void Tol3d(const Standard_Real Tol) ;


Standard_EXPORT   Standard_Real Tolang() const;


Standard_EXPORT   void Tolang(const Standard_Real Tol) ;
//Standard_EXPORT ~GeomFill_Boundary();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


Standard_EXPORT GeomFill_Boundary(const Standard_Real Tol3d,const Standard_Real Tolang);


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Real myT3d;
Standard_Real myTang;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
