// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _GeometryTest_HeaderFile
#define _GeometryTest_HeaderFile

class Draw_Interpretor;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! this  package  provides  commands for  curves  and <br>
//!          surface. <br>
class GeometryTest  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! defines all geometric commands. <br>
Standard_EXPORT static  void AllCommands(Draw_Interpretor& I) ;

//! defines curve commands. <br>
Standard_EXPORT static  void CurveCommands(Draw_Interpretor& I) ;

//! defines fair curve commands. <br>
Standard_EXPORT static  void FairCurveCommands(Draw_Interpretor& I) ;

//! defines surface commands. <br>
Standard_EXPORT static  void SurfaceCommands(Draw_Interpretor& I) ;

//! defines cosntrained curves commands. <br>
Standard_EXPORT static  void ConstraintCommands(Draw_Interpretor& I) ;

//! defines commands to test the Geom2dAPI <br>
//!          - Intersection <br>
//!          - Extrema <br>
//!          - Projection <br>
//!          - Approximation, interpolation <br>
Standard_EXPORT static  void API2dCommands(Draw_Interpretor& I) ;

//! defines commands to test the Geom2dAPI <br>
//!          - Intersection <br>
//!          - Extrema <br>
//!          - Projection <br>
//!          - Approximation, interpolation <br>
Standard_EXPORT static  void APICommands(Draw_Interpretor& I) ;

//! defines commands to check local <br>
//!          continuity between curves or surfaces <br>
Standard_EXPORT static  void ContinuityCommands(Draw_Interpretor& I) ;

//! defines     command  to    test  the    polyhedral <br>
//!          triangulations and the polygons from the Poly package. <br>
Standard_EXPORT static  void PolyCommands(Draw_Interpretor& I) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
