// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IGESBasic_ToolOrderedGroup_HeaderFile
#define _IGESBasic_ToolOrderedGroup_HeaderFile

#ifndef _Handle_IGESBasic_OrderedGroup_HeaderFile
#include <Handle_IGESBasic_OrderedGroup.hxx>
#endif
#ifndef _Handle_IGESData_IGESReaderData_HeaderFile
#include <Handle_IGESData_IGESReaderData.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Interface_Check_HeaderFile
#include <Handle_Interface_Check.hxx>
#endif
#ifndef _Handle_Message_Messenger_HeaderFile
#include <Handle_Message_Messenger.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class Standard_DomainError;
class IGESBasic_OrderedGroup;
class IGESData_IGESReaderData;
class IGESData_ParamReader;
class IGESData_IGESWriter;
class Interface_EntityIterator;
class IGESData_DirChecker;
class Interface_ShareTool;
class Interface_Check;
class Interface_CopyTool;
class IGESData_IGESDumper;
class Message_Messenger;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Tool to work on a OrderedGroup. Called by various Modules <br>
//!           (ReadWriteModule, GeneralModule, SpecificModule) <br>
class IGESBasic_ToolOrderedGroup  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Returns a ToolOrderedGroup, ready to work <br>
Standard_EXPORT IGESBasic_ToolOrderedGroup();

//! Reads own parameters from file. <PR> gives access to them, <br>
//!           <IR> detains parameter types and values <br>
Standard_EXPORT   void ReadOwnParams(const Handle(IGESBasic_OrderedGroup)& ent,const Handle(IGESData_IGESReaderData)& IR,IGESData_ParamReader& PR) const;

//! Writes own parameters to IGESWriter <br>
Standard_EXPORT   void WriteOwnParams(const Handle(IGESBasic_OrderedGroup)& ent,IGESData_IGESWriter& IW) const;

//! Lists the Entities shared by a OrderedGroup <ent>, from <br>
//!           its specific (own) parameters <br>
Standard_EXPORT   void OwnShared(const Handle(IGESBasic_OrderedGroup)& ent,Interface_EntityIterator& iter) const;

//! Sets automatic unambiguous Correction on an OrderedGroup <br>
//!           (Null Elements are removed from list) <br>
Standard_EXPORT   Standard_Boolean OwnCorrect(const Handle(IGESBasic_OrderedGroup)& ent) const;

//! Returns specific DirChecker <br>
Standard_EXPORT   IGESData_DirChecker DirChecker(const Handle(IGESBasic_OrderedGroup)& ent) const;

//! Performs Specific Semantic Check <br>
Standard_EXPORT   void OwnCheck(const Handle(IGESBasic_OrderedGroup)& ent,const Interface_ShareTool& shares,Handle(Interface_Check)& ach) const;

//! Copies Specific Parameters <br>
Standard_EXPORT   void OwnCopy(const Handle(IGESBasic_OrderedGroup)& entfrom,const Handle(IGESBasic_OrderedGroup)& entto,Interface_CopyTool& TC) const;

//! Dump of Specific Parameters <br>
Standard_EXPORT   void OwnDump(const Handle(IGESBasic_OrderedGroup)& ent,const IGESData_IGESDumper& dumper,const Handle(Message_Messenger)& S,const Standard_Integer own) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
