// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IGESGeom_BoundedSurface_HeaderFile
#define _IGESGeom_BoundedSurface_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_IGESGeom_BoundedSurface_HeaderFile
#include <Handle_IGESGeom_BoundedSurface.hxx>
#endif

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_IGESData_IGESEntity_HeaderFile
#include <Handle_IGESData_IGESEntity.hxx>
#endif
#ifndef _Handle_IGESGeom_HArray1OfBoundary_HeaderFile
#include <Handle_IGESGeom_HArray1OfBoundary.hxx>
#endif
#ifndef _IGESData_IGESEntity_HeaderFile
#include <IGESData_IGESEntity.hxx>
#endif
#ifndef _Handle_IGESGeom_Boundary_HeaderFile
#include <Handle_IGESGeom_Boundary.hxx>
#endif
class IGESData_IGESEntity;
class IGESGeom_HArray1OfBoundary;
class Standard_OutOfRange;
class IGESGeom_Boundary;


//! defines BoundedSurface, Type <143> Form <0> <br>
//!          in package IGESGeom <br>
//!          A bounded surface is used to communicate trimmed <br>
//!          surfaces. The surface and trimming curves are assumed <br>
//!          to be represented parametrically. <br>
class IGESGeom_BoundedSurface : public IGESData_IGESEntity {

public:
 // Methods PUBLIC
 // 


Standard_EXPORT IGESGeom_BoundedSurface();

//! This method is used to set the fields of the class <br>
//!           BoundedSurface <br>
//!       - aType     : Type of bounded surface representation <br>
//!       - aSurface  : Surface entity to be bounded <br>
//!       - allBounds : Array of boundary entities <br>
Standard_EXPORT   void Init(const Standard_Integer aType,const Handle(IGESData_IGESEntity)& aSurface,const Handle(IGESGeom_HArray1OfBoundary)& allBounds) ;

//! returns the type of Bounded surface representation <br>
//! 0 = The boundary entities may only reference model space curves <br>
//! 1 = The boundary entities may reference both model space curves <br>
//!     and associated parameter space curve representations <br>
Standard_EXPORT   Standard_Integer RepresentationType() const;

//! returns the bounded surface <br>
Standard_EXPORT   Handle_IGESData_IGESEntity Surface() const;

//! returns the number of boundaries <br>
Standard_EXPORT   Standard_Integer NbBoundaries() const;

//! returns boundary entity <br>
//! raises exception if Index <= 0 or Index > NbBoundaries() <br>
Standard_EXPORT   Handle_IGESGeom_Boundary Boundary(const Standard_Integer Index) const;
//Standard_EXPORT ~IGESGeom_BoundedSurface();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Integer theType;
Handle_IGESData_IGESEntity theSurface;
Handle_IGESGeom_HArray1OfBoundary theBoundaries;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
