// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IGESSolid_ConicalSurface_HeaderFile
#define _IGESSolid_ConicalSurface_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_IGESSolid_ConicalSurface_HeaderFile
#include <Handle_IGESSolid_ConicalSurface.hxx>
#endif

#ifndef _Handle_IGESGeom_Point_HeaderFile
#include <Handle_IGESGeom_Point.hxx>
#endif
#ifndef _Handle_IGESGeom_Direction_HeaderFile
#include <Handle_IGESGeom_Direction.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _IGESData_IGESEntity_HeaderFile
#include <IGESData_IGESEntity.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class IGESGeom_Point;
class IGESGeom_Direction;


//! defines ConicalSurface, Type <194> Form Number <0,1> <br>
//!          in package IGESSolid <br>
//!          The right circular conical surface is defined by a <br>
//!          point on the axis on the cone, the direction of the axis <br>
//!          of the cone, the radius of the cone at the axis point and <br>
//!          the cone semi-angle. <br>
class IGESSolid_ConicalSurface : public IGESData_IGESEntity {

public:
 // Methods PUBLIC
 // 


Standard_EXPORT IGESSolid_ConicalSurface();

//! This method is used to set the fields of the class <br>
//!           ConicalSurface <br>
//!       - aLocation : Location of the point on axis <br>
//!       - anAxis    : Direction of the axis <br>
//!       - aRadius   : Radius at axis point <br>
//!       - anAngle   : Value of semi-angle in degrees (0<angle<90) <br>
//!       - aRefdir   : Reference direction (parametrised surface) <br>
//!                     Null if unparametrised surface. <br>
Standard_EXPORT   void Init(const Handle(IGESGeom_Point)& aLocation,const Handle(IGESGeom_Direction)& anAxis,const Standard_Real aRadius,const Standard_Real anAngle,const Handle(IGESGeom_Direction)& aRefdir) ;

//! returns the location of the point on the axis <br>
Standard_EXPORT   Handle_IGESGeom_Point LocationPoint() const;

//! returns the direction of the axis <br>
Standard_EXPORT   Handle_IGESGeom_Direction Axis() const;

//! returns the radius at the axis point <br>
Standard_EXPORT   Standard_Real Radius() const;

//! returns the semi-angle value <br>
Standard_EXPORT   Standard_Real SemiAngle() const;

//! returns the reference direction of the conical surface in case <br>
//! of parametrised surface. For unparametrised surface it returns <br>
//! NULL. <br>
Standard_EXPORT   Handle_IGESGeom_Direction ReferenceDir() const;

//! returns True if Form no is 1 else false <br>
Standard_EXPORT   Standard_Boolean IsParametrised() const;
//Standard_EXPORT ~IGESSolid_ConicalSurface();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_IGESGeom_Point theLocationPoint;
Handle_IGESGeom_Direction theAxis;
Standard_Real theRadius;
Standard_Real theAngle;
Handle_IGESGeom_Direction theRefDir;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
